/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.search.enums.ProcessInstanceState;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.api.assertions.ElementSelector;
import io.camunda.process.test.api.assertions.ProcessInstanceAssert;
import io.camunda.process.test.api.assertions.ProcessInstanceSelector;
import io.camunda.process.test.api.assertions.ProcessInstanceSelectors;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.ElementAssertj;
import io.camunda.process.test.impl.assertions.IncidentAssertj;
import io.camunda.process.test.impl.assertions.MessageSubscriptionAssertj;
import io.camunda.process.test.impl.assertions.VariableAssertj;
import io.camunda.process.test.impl.assertions.util.CamundaAssertJsonMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowingConsumer;

public class ProcessInstanceAssertj
extends AbstractAssert<ProcessInstanceAssertj, ProcessInstanceSelector>
implements ProcessInstanceAssert {
    private final CamundaDataSource dataSource;
    private final CamundaAssertAwaitBehavior awaitBehavior;
    private final ElementAssertj elementAssertj;
    private final VariableAssertj variableAssertj;
    private final IncidentAssertj incidentAssertj;
    private final MessageSubscriptionAssertj messageSubscriptionAssertj;
    private final String failureMessagePrefix;
    private final Function<String, ElementSelector> elementSelector;
    private final AtomicReference<ProcessInstance> actualProcessInstance = new AtomicReference();

    public ProcessInstanceAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, CamundaAssertJsonMapper jsonMapper, long processInstanceKey, Function<String, ElementSelector> elementSelector) {
        this(dataSource, awaitBehavior, jsonMapper, ProcessInstanceSelectors.byKey(processInstanceKey), elementSelector);
    }

    public ProcessInstanceAssertj(CamundaDataSource dataSource, CamundaAssertAwaitBehavior awaitBehavior, CamundaAssertJsonMapper jsonMapper, ProcessInstanceSelector processInstanceSelector, Function<String, ElementSelector> elementSelector) {
        super((Object)processInstanceSelector, ProcessInstanceAssertj.class);
        this.dataSource = dataSource;
        this.awaitBehavior = awaitBehavior;
        this.failureMessagePrefix = String.format("Process instance [%s]", processInstanceSelector.describe());
        this.elementSelector = elementSelector;
        this.elementAssertj = new ElementAssertj(dataSource, awaitBehavior, this.failureMessagePrefix);
        this.variableAssertj = new VariableAssertj(dataSource, awaitBehavior, jsonMapper, this.failureMessagePrefix);
        this.incidentAssertj = new IncidentAssertj(dataSource, awaitBehavior, this.failureMessagePrefix);
        this.messageSubscriptionAssertj = new MessageSubscriptionAssertj(dataSource, awaitBehavior, this.failureMessagePrefix);
    }

    @Override
    public ProcessInstanceAssert isActive() {
        this.hasProcessInstanceInState("active", arg_0 -> ProcessInstanceState.ACTIVE.equals(arg_0));
        return this;
    }

    @Override
    public ProcessInstanceAssert isCompleted() {
        this.hasProcessInstanceInState("completed", arg_0 -> ProcessInstanceState.COMPLETED.equals(arg_0));
        return this;
    }

    @Override
    public ProcessInstanceAssert isTerminated() {
        this.hasProcessInstanceInState("terminated", arg_0 -> ProcessInstanceState.TERMINATED.equals(arg_0));
        return this;
    }

    @Override
    public ProcessInstanceAssert isCreated() {
        this.hasProcessInstanceInState("created", state -> state == ProcessInstanceState.ACTIVE || state == ProcessInstanceState.COMPLETED || state == ProcessInstanceState.TERMINATED);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElements(String ... elementIds) {
        this.elementAssertj.hasActiveElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasActiveElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElements(String ... elementIds) {
        this.elementAssertj.hasCompletedElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasCompletedElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElementsInOrder(String ... elementIds) {
        this.elementAssertj.hasCompletedElementsInOrder(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElementsInOrder(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasCompletedElementsInOrder(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElements(String ... elementIds) {
        this.elementAssertj.hasTerminatedElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasTerminatedElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElement(String elementId, int times) {
        this.elementAssertj.hasActiveElement(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElement(ElementSelector elementSelector, int times) {
        this.elementAssertj.hasActiveElement(this.getProcessInstanceKey(), elementSelector, times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElement(String elementId, int times) {
        this.elementAssertj.hasCompletedElement(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElement(ElementSelector elementSelector, int times) {
        this.elementAssertj.hasCompletedElement(this.getProcessInstanceKey(), elementSelector, times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElement(String elementId, int times) {
        this.elementAssertj.hasTerminatedElement(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElement(ElementSelector elementSelector, int times) {
        this.elementAssertj.hasTerminatedElement(this.getProcessInstanceKey(), elementSelector, times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNotActivatedElements(String ... elementIds) {
        this.elementAssertj.hasNotActivatedElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNotActivatedElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasNotActivatedElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNoActiveElements(String ... elementIds) {
        this.elementAssertj.hasNoActiveElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNoActiveElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasNoActiveElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElementsExactly(String ... elementIds) {
        this.elementAssertj.hasActiveElementsExactly(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElementsExactly(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasActiveElementsExactly(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariableNames(String ... variableNames) {
        this.variableAssertj.hasVariableNames(this.getProcessInstanceKey(), variableNames);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasLocalVariableNames(String elementId, String ... variableNames) {
        this.variableAssertj.hasLocalVariableNames(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), variableNames);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasLocalVariableNames(ElementSelector selector, String ... variableNames) {
        this.variableAssertj.hasLocalVariableNames(this.getProcessInstanceKey(), selector, variableNames);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariable(String variableName, Object variableValue) {
        this.variableAssertj.hasVariable(this.getProcessInstanceKey(), variableName, variableValue);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasLocalVariable(String elementId, String variableName, Object variableValue) {
        this.variableAssertj.hasLocalVariable(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), variableName, variableValue);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasLocalVariable(ElementSelector selector, String variableName, Object variableValue) {
        this.variableAssertj.hasLocalVariable(this.getProcessInstanceKey(), selector, variableName, variableValue);
        return this;
    }

    @Override
    public <T> ProcessInstanceAssert hasVariableSatisfies(String variableName, Class<T> variableValueType, ThrowingConsumer<T> requirement) {
        this.variableAssertj.hasVariableSatisfies(this.getProcessInstanceKey(), variableName, variableValueType, requirement);
        return this;
    }

    @Override
    public <T> ProcessInstanceAssert hasLocalVariableSatisfies(String elementId, String variableName, Class<T> variableValueType, ThrowingConsumer<T> requirement) {
        return this.hasLocalVariableSatisfies(this.elementSelector.apply(elementId), variableName, variableValueType, requirement);
    }

    @Override
    public <T> ProcessInstanceAssert hasLocalVariableSatisfies(ElementSelector selector, String variableName, Class<T> variableValueType, ThrowingConsumer<T> requirement) {
        this.variableAssertj.hasLocalVariableSatisfies(this.getProcessInstanceKey(), selector, variableName, variableValueType, requirement);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariables(Map<String, Object> variables) {
        this.variableAssertj.hasVariables(this.getProcessInstanceKey(), variables);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasLocalVariables(String elementId, Map<String, Object> variables) {
        this.variableAssertj.hasLocalVariables(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), variables);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasLocalVariables(ElementSelector selector, Map<String, Object> variables) {
        this.variableAssertj.hasLocalVariables(this.getProcessInstanceKey(), selector, variables);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNoActiveIncidents() {
        this.incidentAssertj.hasNoActiveIncidents(this.getProcessInstanceKey());
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveIncidents() {
        this.incidentAssertj.hasActiveIncidents(this.getProcessInstanceKey());
        return this;
    }

    @Override
    public ProcessInstanceAssert isWaitingForMessage(String messageName) {
        this.messageSubscriptionAssertj.isWaitingForMessage(this.getProcessInstanceKey(), messageName);
        return this;
    }

    @Override
    public ProcessInstanceAssert isWaitingForMessage(String messageName, String correlationKey) {
        this.messageSubscriptionAssertj.isWaitingForMessage(this.getProcessInstanceKey(), messageName, correlationKey);
        return this;
    }

    @Override
    public ProcessInstanceAssert isNotWaitingForMessage(String messageName) {
        this.messageSubscriptionAssertj.isNotWaitingForMessage(this.getProcessInstanceKey(), messageName);
        return this;
    }

    @Override
    public ProcessInstanceAssert isNotWaitingForMessage(String messageName, String correlationKey) {
        this.messageSubscriptionAssertj.isNotWaitingForMessage(this.getProcessInstanceKey(), messageName, correlationKey);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCorrelatedMessage(String messageName) {
        this.messageSubscriptionAssertj.hasCorrelatedMessage(this.getProcessInstanceKey(), messageName);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCorrelatedMessage(String messageName, String correlationKey) {
        this.messageSubscriptionAssertj.hasCorrelatedMessage(this.getProcessInstanceKey(), messageName, correlationKey);
        return this;
    }

    private void hasProcessInstanceInState(String expectedState, Predicate<ProcessInstanceState> expectedStateMatcher) {
        this.awaitBehavior.untilAsserted(this::findProcessInstance, processInstance -> {
            processInstance.ifPresent(this.actualProcessInstance::set);
            ((OptionalAssert)Assertions.assertThat((Optional)processInstance).withFailMessage("%s should be %s but was not created.", new Object[]{this.failureMessagePrefix, expectedState})).isPresent();
            ProcessInstanceState actualState = ((ProcessInstance)processInstance.get()).getState();
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualState).withFailMessage("%s should be %s but was %s.", new Object[]{this.failureMessagePrefix, expectedState, ProcessInstanceAssertj.formatState(actualState)})).matches(expectedStateMatcher);
        });
    }

    private Optional<ProcessInstance> findProcessInstance() {
        return this.dataSource.findProcessInstances(((ProcessInstanceSelector)this.actual)::applyFilter).stream().filter(((ProcessInstanceSelector)this.actual)::test).findFirst();
    }

    private void awaitProcessInstance() {
        this.awaitBehavior.untilAsserted(this::findProcessInstance, processInstance -> {
            processInstance.ifPresent(this.actualProcessInstance::set);
            ((OptionalAssert)Assertions.assertThat((Optional)processInstance).withFailMessage("No process instance [%s] found.", new Object[]{((ProcessInstanceSelector)this.actual).describe()})).isPresent();
        });
    }

    private long getProcessInstanceKey() {
        if (this.actualProcessInstance.get() == null) {
            this.awaitProcessInstance();
        }
        return this.actualProcessInstance.get().getProcessInstanceKey();
    }

    private static String formatState(ProcessInstanceState state) {
        if (state == null || state == ProcessInstanceState.UNKNOWN_ENUM_VALUE) {
            return "not created";
        }
        return state.name().toLowerCase();
    }

    private List<ElementSelector> toElementSelectors(String[] elementIds) {
        return Arrays.stream(elementIds).map(this.elementSelector).collect(Collectors.toList());
    }
}

