/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions.util;

import io.camunda.client.api.command.ClientException;
import io.camunda.process.test.api.CamundaAssert;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.shaded.awaitility.Awaitility;
import io.camunda.shaded.awaitility.core.ConditionTimeoutException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertionsProvider;

public class AwaitilityBehavior
implements CamundaAssertAwaitBehavior {
    private static final String INITIAL_FAILURE_MESSAGE = "<No assertion error occurred. Maybe, the assertion timed out before it could be tested.>";
    private Duration assertionTimeout = CamundaAssert.DEFAULT_ASSERTION_TIMEOUT;
    private Duration assertionInterval = CamundaAssert.DEFAULT_ASSERTION_INTERVAL;

    @Override
    public void untilAsserted(SoftAssertionsProvider.ThrowingRunnable assertion) throws AssertionError {
        AtomicReference<String> failureMessage = new AtomicReference<String>(INITIAL_FAILURE_MESSAGE);
        try {
            Awaitility.await().timeout(this.assertionTimeout).pollInterval(this.assertionInterval).ignoreException(ClientException.class).untilAsserted(() -> {
                try {
                    assertion.run();
                }
                catch (AssertionError e) {
                    failureMessage.set(((Throwable)((Object)e)).getMessage());
                    throw e;
                }
            });
        }
        catch (ConditionTimeoutException ignore) {
            Assertions.fail((String)failureMessage.get());
        }
    }

    @Override
    public void setAssertionTimeout(Duration assertionTimeout) {
        this.assertionTimeout = assertionTimeout;
    }

    @Override
    public void setAssertionInterval(Duration assertionInterval) {
        this.assertionInterval = assertionInterval;
    }
}

