/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import io.camunda.client.api.command.InternalClientException;
import io.camunda.zeebe.client.api.JsonMapper;

public class CamundaAssertJsonMapper {
    private final io.camunda.client.api.JsonMapper jsonMapper;
    private final JsonMapper zeebeJsonMapper;

    public CamundaAssertJsonMapper(io.camunda.client.api.JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.zeebeJsonMapper = null;
    }

    public CamundaAssertJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = null;
        this.zeebeJsonMapper = jsonMapper;
    }

    public JsonNode readJson(String value) {
        return (JsonNode)this.readJson(value, JsonNode.class, NullNode.getInstance());
    }

    public <T> T readJson(String value, Class<T> clazz) {
        return this.readJson(value, clazz, null);
    }

    public <T> T readJson(String value, Class<T> clazz, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return this.read(value, clazz);
        }
        catch (InternalClientException e) {
            throw new JsonMappingException(String.format("Failed to read JSON: '%s'", value), e);
        }
    }

    public JsonNode toJsonNode(Object value) {
        try {
            return this.write(value);
        }
        catch (InternalClientException e) {
            throw new JsonMappingException(String.format("Failed to transform value to JSON: '%s'", value), e);
        }
    }

    private <T> T read(String value, Class<T> clazz) {
        if (this.jsonMapper != null) {
            return (T)this.jsonMapper.fromJson(value, clazz);
        }
        return (T)this.zeebeJsonMapper.fromJson(value, clazz);
    }

    private JsonNode write(Object value) {
        if (this.jsonMapper != null) {
            return (JsonNode)this.jsonMapper.transform(value, JsonNode.class);
        }
        return (JsonNode)this.zeebeJsonMapper.fromJson(this.zeebeJsonMapper.toJson(value), JsonNode.class);
    }

    public static class JsonMappingException
    extends RuntimeException {
        public JsonMappingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

