/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.containers;

import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.containers.ConnectorsContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

public class ContainerFactory {
    public ElasticsearchContainer createElasticsearchContainer(String imageName, String imageVersion) {
        return new ElasticsearchContainer(ContainerFactory.asDockerImageName(imageName, imageVersion));
    }

    public CamundaContainer createCamundaContainer(String imageName, String imageVersion) {
        return new CamundaContainer(ContainerFactory.asDockerImageName(imageName, imageVersion));
    }

    public ConnectorsContainer createConnectorsContainer(String imageName, String imageVersion) {
        return new ConnectorsContainer(ContainerFactory.asDockerImageName(imageName, imageVersion));
    }

    private static DockerImageName asDockerImageName(String imageName, String imageVersion) {
        return DockerImageName.parse((String)imageName).withTag(imageVersion);
    }
}

