/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.extension;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.response.ActivateJobsResponse;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.search.request.UserTaskSearchRequest;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.process.test.api.CamundaAssertAwaitBehavior;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.api.assertions.UserTaskSelector;
import io.camunda.process.test.api.assertions.UserTaskSelectors;
import io.camunda.process.test.api.mock.JobWorkerMockBuilder;
import io.camunda.process.test.impl.client.CamundaManagementClient;
import io.camunda.process.test.impl.mock.JobWorkerMockBuilderImpl;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.LiteralExpression;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaProcessTestContextImpl
implements CamundaProcessTestContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaProcessTestContextImpl.class);
    private final URI camundaRestApiAddress;
    private final URI camundaGrpcApiAddress;
    private final URI connectorsRestApiAddress;
    private final CamundaClientBuilderFactory camundaClientBuilderFactory;
    private final Consumer<AutoCloseable> clientCreationCallback;
    private final CamundaManagementClient camundaManagementClient;
    private final JsonMapper jsonMapper;
    private final io.camunda.zeebe.client.api.JsonMapper zeebeJsonMapper;
    private final CamundaAssertAwaitBehavior awaitBehavior;

    public CamundaProcessTestContextImpl(CamundaProcessTestRuntime camundaRuntime, Consumer<AutoCloseable> clientCreationCallback, CamundaManagementClient camundaManagementClient, CamundaAssertAwaitBehavior awaitBehavior, JsonMapper jsonMapper, io.camunda.zeebe.client.api.JsonMapper zeebeJsonMapper) {
        this.camundaClientBuilderFactory = camundaRuntime.getCamundaClientBuilderFactory();
        this.camundaRestApiAddress = camundaRuntime.getCamundaRestApiAddress();
        this.camundaGrpcApiAddress = camundaRuntime.getCamundaGrpcApiAddress();
        this.connectorsRestApiAddress = camundaRuntime.getConnectorsRestApiAddress();
        this.clientCreationCallback = clientCreationCallback;
        this.camundaManagementClient = camundaManagementClient;
        this.awaitBehavior = awaitBehavior;
        this.jsonMapper = jsonMapper;
        this.zeebeJsonMapper = zeebeJsonMapper;
    }

    @Override
    public CamundaClient createClient() {
        return this.createClient(builder -> {
            if (this.jsonMapper != null) {
                builder.withJsonMapper(this.jsonMapper);
            }
        });
    }

    @Override
    public CamundaClient createClient(Consumer<CamundaClientBuilder> modifier) {
        CamundaClientBuilder builder = (CamundaClientBuilder)this.camundaClientBuilderFactory.get();
        builder.preferRestOverGrpc(false);
        modifier.accept(builder);
        CamundaClient client = builder.build();
        this.clientCreationCallback.accept((AutoCloseable)client);
        return client;
    }

    @Override
    public ZeebeClient createZeebeClient() {
        return this.createZeebeClient(builder -> {
            if (this.zeebeJsonMapper != null) {
                builder.withJsonMapper(this.zeebeJsonMapper);
            }
        });
    }

    @Override
    public ZeebeClient createZeebeClient(Consumer<ZeebeClientBuilder> modifier) {
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().usePlaintext().grpcAddress(this.getCamundaGrpcAddress()).restAddress(this.getCamundaRestAddress());
        modifier.accept(builder);
        ZeebeClient client = builder.build();
        this.clientCreationCallback.accept((AutoCloseable)client);
        return client;
    }

    @Override
    public URI getCamundaGrpcAddress() {
        return this.camundaGrpcApiAddress;
    }

    @Override
    public URI getCamundaRestAddress() {
        return this.camundaRestApiAddress;
    }

    @Override
    public URI getConnectorsAddress() {
        return this.connectorsRestApiAddress;
    }

    @Override
    public Instant getCurrentTime() {
        return this.camundaManagementClient.getCurrentTime();
    }

    @Override
    public void increaseTime(Duration timeToAdd) {
        LOGGER.debug("Increase the time by {}", (Object)timeToAdd);
        this.camundaManagementClient.increaseTime(timeToAdd);
    }

    @Override
    public void setTime(Instant timeToSet) {
        LOGGER.debug("Setting the time to {}", (Object)timeToSet);
        this.camundaManagementClient.setTime(timeToSet);
    }

    @Override
    public JobWorkerMockBuilder mockJobWorker(String jobType) {
        CamundaClient client = this.createClient();
        return new JobWorkerMockBuilderImpl(jobType, client);
    }

    @Override
    public void mockChildProcess(String childProcessId) {
        this.mockChildProcess(childProcessId, Collections.emptyMap());
    }

    @Override
    public void mockChildProcess(String childProcessId, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        BpmnModelInstance processModel = Bpmn.createExecutableProcess((String)childProcessId).startEvent().endEvent("child-end", e -> variables.forEach((k, v) -> e.zeebeOutput("=" + client.getConfiguration().getJsonMapper().toJson(v), k))).done();
        LOGGER.debug("Mock: Deploy a child process '{}' with result variables {}", (Object)childProcessId, variables);
        String resourceName = childProcessId + ".bpmn";
        client.newDeployResourceCommand().addProcessModel(processModel, resourceName).send().join();
    }

    @Override
    public void completeJob(String jobType) {
        this.completeJob(jobType, Collections.emptyMap());
    }

    @Override
    public void completeJob(String jobType, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        ActivatedJob job = this.getActivatedJob(jobType);
        LOGGER.debug("Complete job with variables {} [job-type: '{}', job-key: '{}']", new Object[]{variables, jobType, job.getKey()});
        client.newCompleteCommand(job).variables(variables).send().join();
    }

    @Override
    public void throwBpmnErrorFromJob(String jobType, String errorCode) {
        this.throwBpmnErrorFromJob(jobType, errorCode, Collections.emptyMap());
    }

    @Override
    public void throwBpmnErrorFromJob(String jobType, String errorCode, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        ActivatedJob job = this.getActivatedJob(jobType);
        LOGGER.debug("Throw BPMN error with error code {} and variables {} [job-type: '{}', job-key: '{}']", new Object[]{errorCode, variables, jobType, job.getKey()});
        client.newThrowErrorCommand(job).errorCode(errorCode).variables(variables).send().join();
    }

    @Override
    public void completeUserTask(String elementId) {
        this.completeUserTask(UserTaskSelectors.byElementId(elementId), Collections.emptyMap());
    }

    @Override
    public void completeUserTask(String elementId, Map<String, Object> variables) {
        this.completeUserTask(UserTaskSelectors.byElementId(elementId), variables);
    }

    @Override
    public void completeUserTask(UserTaskSelector userTaskSelector) {
        this.completeUserTask(userTaskSelector, Collections.emptyMap());
    }

    @Override
    public void completeUserTask(UserTaskSelector userTaskSelector, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        AtomicReference userTaskKey = new AtomicReference();
        this.awaitBehavior.untilAsserted(() -> {
            Optional<UserTask> userTask = ((SearchResponse)((UserTaskSearchRequest)client.newUserTaskSearchRequest().filter(userTaskSelector::applyFilter)).send().join()).items().stream().filter(userTaskSelector::test).findFirst();
            userTask.map(UserTask::getUserTaskKey).ifPresent(userTaskKey::set);
            ((OptionalAssert)Assertions.assertThat(userTask).withFailMessage("Expected to complete user task [%s] but no user task is available.", new Object[]{userTaskSelector.describe()})).isPresent();
        });
        LOGGER.debug("Complete user task with variables {} [user-task-key: '{}']", variables, userTaskKey.get());
        client.newCompleteUserTaskCommand(((Long)userTaskKey.get()).longValue()).variables(variables).send().join();
    }

    @Override
    public void mockDmnDecision(String decisionId, Object decisionOutput) {
        CamundaClient client = this.createClient();
        String jsonVariables = client.getConfiguration().getJsonMapper().toJson(decisionOutput);
        DmnModelInstance modelInstance = Dmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setName(decisionId + "-name");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        modelInstance.setDefinitions(definitions);
        Decision decision = (Decision)modelInstance.newInstance(Decision.class);
        decision.setId(decisionId);
        decision.setName(decisionId + "-decision-name");
        definitions.addChildElement((ModelElementInstance)decision);
        LiteralExpression literalExpression = (LiteralExpression)modelInstance.newInstance(LiteralExpression.class);
        Text text = (Text)modelInstance.newInstance(Text.class);
        text.setTextContent(jsonVariables);
        literalExpression.setText(text);
        decision.addChildElement((ModelElementInstance)literalExpression);
        LOGGER.debug("Mock: Deploy a DMN '{}' with decision output {}", (Object)decisionId, decisionOutput);
        String resourceName = decisionId + ".dmn";
        client.newDeployResourceCommand().addResourceStream((InputStream)new ByteArrayInputStream(Dmn.convertToString((DmnModelInstance)modelInstance).getBytes()), resourceName).send().join();
    }

    private ActivatedJob getActivatedJob(String jobType) {
        CamundaClient client = this.createClient();
        AtomicReference activatedJob = new AtomicReference();
        this.awaitBehavior.untilAsserted(() -> {
            Optional firstActivatedJob = ((ActivateJobsResponse)client.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(1).requestTimeout(Duration.ofSeconds(1L)).send().join()).getJobs().stream().findFirst();
            firstActivatedJob.ifPresent(activatedJob::set);
            ((OptionalAssert)Assertions.assertThat(firstActivatedJob).withFailMessage("Expected to complete a job with the type '%s' but no job is available.", new Object[]{jobType})).isPresent();
        });
        return (ActivatedJob)activatedJob.get();
    }
}

