/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.mock;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.process.test.api.mock.JobWorkerMockBuilder;
import io.camunda.process.test.impl.mock.JobWorkerMockImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerMockBuilderImpl
implements JobWorkerMockBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerMockBuilderImpl.class);
    private final String jobType;
    private final CamundaClient client;

    public JobWorkerMockBuilderImpl(String jobType, CamundaClient client) {
        this.jobType = jobType;
        this.client = client;
    }

    @Override
    public JobWorkerMockBuilder.JobWorkerMock thenComplete() {
        return this.thenComplete(new HashMap<String, Object>());
    }

    @Override
    public JobWorkerMockBuilder.JobWorkerMock thenComplete(Map<String, Object> variables) {
        return this.withHandler((jobClient, job) -> {
            LOGGER.debug("Mock: Complete job with variables {} [job-type: '{}', job-key: '{}']", new Object[]{variables, this.jobType, job.getKey()});
            jobClient.newCompleteCommand(job).variables(variables).send().join();
        });
    }

    @Override
    public JobWorkerMockBuilder.JobWorkerMock thenThrowBpmnError(String errorCode) {
        return this.thenThrowBpmnError(errorCode, new HashMap<String, Object>());
    }

    @Override
    public JobWorkerMockBuilder.JobWorkerMock thenThrowBpmnError(String errorCode, Map<String, Object> variables) {
        return this.withHandler((jobClient, job) -> {
            LOGGER.debug("Mock: Throw BPMN error with error code {} and variables {} [job-type: '{}', job-key: '{}']", new Object[]{errorCode, variables, this.jobType, job.getKey()});
            jobClient.newThrowErrorCommand(job).errorCode(errorCode).variables(variables).send().join();
        });
    }

    @Override
    public JobWorkerMockBuilder.JobWorkerMock withHandler(JobHandler jobHandler) {
        return new JobWorkerMockImpl(this.jobType, this.client, jobHandler);
    }
}

