/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CredentialsProvider;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.containers.ConnectorsContainer;
import io.camunda.process.test.impl.containers.ContainerFactory;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import io.camunda.process.test.impl.runtime.logging.CamundaLogEntry;
import io.camunda.process.test.impl.runtime.logging.ConnectorsLogEntry;
import io.camunda.process.test.impl.runtime.logging.LogEntry;
import io.camunda.process.test.impl.runtime.logging.Slf4jJsonLogConsumer;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class CamundaProcessTestContainerRuntime
implements AutoCloseable,
CamundaProcessTestRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaProcessTestContainerRuntime.class);
    private static final String NETWORK_ALIAS_CAMUNDA = "camunda";
    private static final String NETWORK_ALIAS_ELASTICSEARCH = "elasticsearch";
    private static final String NETWORK_ALIAS_CONNECTORS = "connectors";
    private static final String ELASTICSEARCH_URL = "http://elasticsearch:9200";
    private static final String CAMUNDA_GRPC_API = "http://camunda:26500";
    private static final String CAMUNDA_REST_API = "http://camunda:8080";
    private static final URI DISABLED_CONNECTORS_ADDRESS = URI.create("http://connectors:8080/disabled");
    private final ContainerFactory containerFactory;
    private final Network network;
    private final CamundaContainer camundaContainer;
    private final ConnectorsContainer connectorsContainer;
    private final boolean isMultiTenancyEnabled;
    private final boolean connectorsEnabled;

    CamundaProcessTestContainerRuntime(CamundaProcessTestRuntimeBuilder builder, ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        this.isMultiTenancyEnabled = builder.isMultiTenancyEnabled();
        this.connectorsEnabled = builder.isConnectorsEnabled();
        this.network = Network.newNetwork();
        this.camundaContainer = this.createCamundaContainer(this.network, builder);
        this.connectorsContainer = this.createConnectorsContainer(this.network, builder);
        if (this.isMultiTenancyEnabled) {
            LOGGER.debug("Multi-tenancy has been enabled. The API is now secured and requires basic authentication. An admin user is created. [username: '{}', password: '{}']", (Object)"demo", (Object)"demo");
        }
    }

    private ElasticsearchContainer createElasticsearchContainer(Network network, CamundaProcessTestRuntimeBuilder builder) {
        ElasticsearchContainer container = (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)this.containerFactory.createElasticsearchContainer(builder.getElasticsearchDockerImageName(), builder.getElasticsearchDockerImageVersion()).withLogConsumer((Consumer)CamundaProcessTestContainerRuntime.createContainerLogger(builder.getElasticsearchLoggerName()))).withNetwork(network)).withNetworkAliases(new String[]{NETWORK_ALIAS_ELASTICSEARCH})).withEnv("xpack.security.enabled", "false")).withEnv(builder.getElasticsearchEnvVars());
        builder.getElasticsearchExposedPorts().forEach(arg_0 -> ((ElasticsearchContainer)container).addExposedPort(arg_0));
        return container;
    }

    private CamundaContainer createCamundaContainer(Network network, CamundaProcessTestRuntimeBuilder builder) {
        CamundaContainer container = (CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)this.containerFactory.createCamundaContainer(builder.getCamundaDockerImageName(), builder.getCamundaDockerImageVersion()).withLogConsumer(CamundaProcessTestContainerRuntime.createContainerJsonLogger(builder.getCamundaLoggerName(), CamundaLogEntry.class))).withNetwork(network)).withNetworkAliases(new String[]{NETWORK_ALIAS_CAMUNDA})).withAccessToHost(true);
        if (this.isMultiTenancyEnabled) {
            container.withMultiTenancy();
        }
        container.withEnv(builder.getCamundaEnvVars());
        builder.getCamundaExposedPorts().forEach(arg_0 -> ((CamundaContainer)container).addExposedPort(arg_0));
        return container;
    }

    private ConnectorsContainer createConnectorsContainer(Network network, CamundaProcessTestRuntimeBuilder builder) {
        ConnectorsContainer container = (ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)this.containerFactory.createConnectorsContainer(builder.getConnectorsDockerImageName(), builder.getConnectorsDockerImageVersion()).withLogConsumer(CamundaProcessTestContainerRuntime.createContainerJsonLogger(builder.getConnectorsLoggerName(), ConnectorsLogEntry.class))).withNetwork(network)).withNetworkAliases(new String[]{NETWORK_ALIAS_CONNECTORS})).withZeebeGrpcApi(CAMUNDA_GRPC_API).withOperateApi(CAMUNDA_REST_API).withEnv(builder.getConnectorsSecrets())).withAccessToHost(true);
        if (this.isMultiTenancyEnabled) {
            container.withMultiTenancy();
        }
        container.withEnv(builder.getConnectorsEnvVars());
        builder.getConnectorsExposedPorts().forEach(arg_0 -> ((ConnectorsContainer)container).addExposedPort(arg_0));
        return container;
    }

    @Override
    public void start() {
        ArrayList<GenericContainer> containers = new ArrayList<GenericContainer>();
        containers.add(this.camundaContainer);
        if (this.connectorsEnabled) {
            containers.add(this.connectorsContainer);
        }
        LOGGER.info("Starting Camunda container runtime [{}]", (Object)containers.stream().map(GenericContainer::getDockerImageName).collect(Collectors.joining(", ")));
        Instant startTime = Instant.now();
        containers.forEach(GenericContainer::start);
        Instant endTime = Instant.now();
        Duration startupTime = Duration.between(startTime, endTime);
        LOGGER.info("Camunda container runtime started in {}", (Object)startupTime);
    }

    @Override
    public URI getCamundaRestApiAddress() {
        return this.getCamundaContainer().getRestApiAddress();
    }

    @Override
    public URI getCamundaGrpcApiAddress() {
        return this.getCamundaContainer().getGrpcApiAddress();
    }

    @Override
    public URI getCamundaMonitoringApiAddress() {
        return this.getCamundaContainer().getMonitoringApiAddress();
    }

    @Override
    public URI getConnectorsRestApiAddress() {
        if (this.connectorsEnabled) {
            return this.getConnectorsContainer().getRestApiAddress();
        }
        return DISABLED_CONNECTORS_ADDRESS;
    }

    @Override
    public CamundaClientBuilderFactory getCamundaClientBuilderFactory() {
        return () -> {
            CamundaClientBuilder client = CamundaClient.newClientBuilder().restAddress(this.getCamundaRestApiAddress()).grpcAddress(this.getCamundaGrpcApiAddress());
            if (this.isMultiTenancyEnabled) {
                client.credentialsProvider((CredentialsProvider)CredentialsProvider.newBasicAuthCredentialsProviderBuilder().username("demo").password("demo").build());
            }
            return client;
        };
    }

    public CamundaContainer getCamundaContainer() {
        return this.camundaContainer;
    }

    public ConnectorsContainer getConnectorsContainer() {
        return this.connectorsContainer;
    }

    @Override
    public void close() throws Exception {
        LOGGER.info("Stopping Camunda container runtime");
        Instant startTime = Instant.now();
        if (this.connectorsEnabled) {
            this.connectorsContainer.stop();
        }
        this.camundaContainer.stop();
        this.network.close();
        Instant endTime = Instant.now();
        Duration shutdownTime = Duration.between(startTime, endTime);
        LOGGER.info("Camunda container runtime stopped in {}", (Object)shutdownTime);
    }

    private static Slf4jLogConsumer createContainerLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new Slf4jLogConsumer(logger, true);
    }

    private static <T extends LogEntry> Slf4jJsonLogConsumer createContainerJsonLogger(String name, Class<T> logEntryType) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new Slf4jJsonLogConsumer(logger, logEntryType);
    }

    public static CamundaProcessTestRuntimeBuilder newBuilder() {
        return new CamundaProcessTestRuntimeBuilder();
    }

    public static CamundaProcessTestRuntime newDefaultRuntime() {
        return CamundaProcessTestContainerRuntime.newBuilder().build();
    }
}

