/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.api.CamundaProcessTestRuntimeMode;
import io.camunda.process.test.impl.runtime.properties.CamundaContainerRuntimeProperties;
import io.camunda.process.test.impl.runtime.properties.ConnectorsContainerRuntimeProperties;
import io.camunda.process.test.impl.runtime.properties.CoverageReportProperties;
import io.camunda.process.test.impl.runtime.properties.RemoteRuntimeProperties;
import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerRuntimePropertiesUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ContainerRuntimePropertiesUtil.class);
    public static final String RUNTIME_VERSION_PROPERTIES_FILE = "camunda-container-runtime-version.properties";
    public static final String USER_RUNTIME_PROPERTIES_FILE = "camunda-container-runtime.properties";
    public static final String PROPERTY_NAME_RUNTIME_MODE = "runtimeMode";
    public static final String PROPERTY_NAME_ELASTICSEARCH_VERSION = "elasticsearch.version";
    public static final String PROPERTY_NAME_MULTI_TENANCY_ENABLED = "multiTenancyEnabled";
    private static final String BASE_DIR = "/";
    private final CamundaContainerRuntimeProperties camundaContainerRuntimeProperties;
    private final ConnectorsContainerRuntimeProperties connectorsContainerRuntimeProperties;
    private final RemoteRuntimeProperties remoteRuntimeProperties;
    private final CoverageReportProperties coverageReportProperties;
    private final CamundaProcessTestRuntimeMode runtimeMode;
    private final boolean multiTenancyEnabled;
    private final String elasticsearchVersion;

    public ContainerRuntimePropertiesUtil(Properties properties) {
        this.elasticsearchVersion = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_ELASTICSEARCH_VERSION, "8.13.0");
        this.camundaContainerRuntimeProperties = new CamundaContainerRuntimeProperties(properties);
        this.connectorsContainerRuntimeProperties = new ConnectorsContainerRuntimeProperties(properties);
        this.remoteRuntimeProperties = new RemoteRuntimeProperties(properties);
        this.coverageReportProperties = new CoverageReportProperties(properties);
        this.runtimeMode = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_RUNTIME_MODE, v -> ContainerRuntimePropertiesUtil.parseRuntimeModeOrDefault(v, CamundaProcessTestRuntimeMode.MANAGED), CamundaProcessTestRuntimeMode.MANAGED);
        this.multiTenancyEnabled = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_MULTI_TENANCY_ENABLED, "false").trim().equalsIgnoreCase("true");
    }

    public static ContainerRuntimePropertiesUtil readProperties() {
        return new ContainerRuntimePropertiesUtil(ContainerRuntimePropertiesUtil.readPropertiesFileWithUserOverrides(BASE_DIR));
    }

    static ContainerRuntimePropertiesUtil readProperties(String directoryOverride) {
        return new ContainerRuntimePropertiesUtil(ContainerRuntimePropertiesUtil.readPropertiesFileWithUserOverrides(directoryOverride));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Properties readPropertiesFileWithUserOverrides(String dir) {
        try (InputStream versionPropertiesFileStream = ContainerRuntimePropertiesUtil.class.getResourceAsStream(dir + RUNTIME_VERSION_PROPERTIES_FILE);){
            Properties properties;
            block15: {
                InputStream userOverridePropertiesFileStream = ContainerRuntimePropertiesUtil.readFileOrNull(dir + USER_RUNTIME_PROPERTIES_FILE);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(versionPropertiesFileStream);
                    if (userOverridePropertiesFileStream != null) {
                        properties2.load(userOverridePropertiesFileStream);
                    }
                    properties = properties2;
                    if (userOverridePropertiesFileStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (userOverridePropertiesFileStream != null) {
                        try {
                            userOverridePropertiesFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                userOverridePropertiesFileStream.close();
            }
            return properties;
        }
        catch (IOException e) {
            LOGGER.warn("Can't read required properties file: {}", (Object)RUNTIME_VERSION_PROPERTIES_FILE, (Object)e);
            return new Properties();
        }
    }

    private static InputStream readFileOrNull(String fileName) {
        try {
            return ContainerRuntimePropertiesUtil.class.getResourceAsStream(fileName);
        }
        catch (Throwable t) {
            LOGGER.warn("Can't read properties file: {}. Skipping.", (Object)fileName, (Object)t);
            return null;
        }
    }

    private static CamundaProcessTestRuntimeMode parseRuntimeModeOrDefault(String value, CamundaProcessTestRuntimeMode defaultValue) {
        try {
            return CamundaProcessTestRuntimeMode.valueOf(value.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public String getCamundaVersion() {
        return this.camundaContainerRuntimeProperties.getCamundaVersion();
    }

    public String getElasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public String getCamundaDockerImageName() {
        return this.camundaContainerRuntimeProperties.getCamundaDockerImageName();
    }

    public String getCamundaDockerImageVersion() {
        return this.camundaContainerRuntimeProperties.getCamundaDockerImageVersion();
    }

    public Map<String, String> getCamundaEnvVars() {
        return this.camundaContainerRuntimeProperties.getCamundaEnvVars();
    }

    public List<Integer> getCamundaExposedPorts() {
        return this.camundaContainerRuntimeProperties.getCamundaExposedPorts();
    }

    public String getCamundaLoggerName() {
        return this.camundaContainerRuntimeProperties.getCamundaLoggerName();
    }

    public String getConnectorsLoggerName() {
        return this.camundaContainerRuntimeProperties.getConnectorsLoggerName();
    }

    public String getConnectorsDockerImageName() {
        return this.connectorsContainerRuntimeProperties.getConnectorsDockerImageName();
    }

    public String getConnectorsDockerImageVersion() {
        return this.connectorsContainerRuntimeProperties.getConnectorsDockerImageVersion();
    }

    public boolean isConnectorsEnabled() {
        return this.connectorsContainerRuntimeProperties.isConnectorsEnabled();
    }

    public Map<String, String> getConnectorsEnvVars() {
        return this.connectorsContainerRuntimeProperties.getConnectorsEnvVars();
    }

    public Map<String, String> getConnectorsSecrets() {
        return this.connectorsContainerRuntimeProperties.getConnectorsSecrets();
    }

    public List<Integer> getConnectorsExposedPorts() {
        return this.connectorsContainerRuntimeProperties.getConnectorsExposedPorts();
    }

    public URI getRemoteCamundaMonitoringApiAddress() {
        return this.remoteRuntimeProperties.getCamundaMonitoringApiAddress();
    }

    public URI getRemoteConnectorsRestApiAddress() {
        return this.remoteRuntimeProperties.getConnectorsRestApiAddress();
    }

    public URI getRemoteClientGrpcAddress() {
        return this.remoteRuntimeProperties.getRemoteClientProperties().getGrpcAddress();
    }

    public URI getRemoteClientRestAddress() {
        return this.remoteRuntimeProperties.getRemoteClientProperties().getRestAddress();
    }

    public CamundaProcessTestRuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    public CamundaClientBuilderFactory getCamundaClientBuilderFactory() {
        return this.remoteRuntimeProperties.getRemoteClientProperties().getClientBuilderFactory();
    }

    public RemoteRuntimeProperties getRemoteRuntimeProperties() {
        return this.remoteRuntimeProperties;
    }

    public boolean isMultiTenancyEnabled() {
        return this.multiTenancyEnabled;
    }

    public CoverageReportProperties getCoverageReportProperties() {
        return this.coverageReportProperties;
    }
}

