/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.properties;

import io.camunda.process.test.impl.runtime.util.PropertiesUtil;
import io.camunda.process.test.impl.runtime.util.VersionedPropertiesUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CamundaContainerRuntimeProperties {
    public static final String PROPERTY_NAME_CAMUNDA_VERSION = "camunda.version";
    public static final String PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_NAME = "camundaDockerImageName";
    public static final String PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_VERSION = "camundaDockerImageVersion";
    public static final String PROPERTY_NAME_CAMUNDA_ENV_VARS_PREFIX = "camundaEnvVars";
    public static final String PROPERTY_NAME_CAMUNDA_EXPOSED_PORTS_PREFIX = "camundaExposedPorts";
    public static final String PROPERTY_NAME_CAMUNDA_LOGGER_NAME = "camundaLoggerName";
    public static final String PROPERTY_NAME_CONNECTORS_LOGGER_NAME = "connectorsLoggerName";
    private final String camundaVersion;
    private final String camundaDockerImageName;
    private final String camundaDockerImageVersion;
    private final Map<String, String> camundaEnvVars;
    private final List<Integer> camundaExposedPorts;
    private final String camundaLoggerName;
    private final String connectorsLoggerName;

    public CamundaContainerRuntimeProperties(Properties properties) {
        this.camundaVersion = VersionedPropertiesUtil.getLatestReleasedVersion(properties, PROPERTY_NAME_CAMUNDA_VERSION, "SNAPSHOT");
        this.camundaDockerImageName = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_NAME, "camunda/camunda");
        this.camundaDockerImageVersion = VersionedPropertiesUtil.getLatestReleasedVersion(properties, PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_VERSION, "SNAPSHOT");
        this.camundaEnvVars = PropertiesUtil.getPropertyMapOrEmpty(properties, PROPERTY_NAME_CAMUNDA_ENV_VARS_PREFIX);
        this.camundaExposedPorts = PropertiesUtil.getPropertyListOrEmpty(properties, PROPERTY_NAME_CAMUNDA_EXPOSED_PORTS_PREFIX, Integer::parseInt);
        this.camundaLoggerName = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CAMUNDA_LOGGER_NAME, "tc.camunda");
        this.connectorsLoggerName = PropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CONNECTORS_LOGGER_NAME, "tc.connectors");
    }

    public String getCamundaVersion() {
        return this.camundaVersion;
    }

    public String getCamundaDockerImageName() {
        return this.camundaDockerImageName;
    }

    public String getCamundaDockerImageVersion() {
        return this.camundaDockerImageVersion;
    }

    public Map<String, String> getCamundaEnvVars() {
        return this.camundaEnvVars;
    }

    public List<Integer> getCamundaExposedPorts() {
        return this.camundaExposedPorts;
    }

    public String getCamundaLoggerName() {
        return this.camundaLoggerName;
    }

    public String getConnectorsLoggerName() {
        return this.connectorsLoggerName;
    }
}

