/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime.util;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.impl.NoopCredentialsProvider;
import io.camunda.client.impl.basicauth.BasicAuthCredentialsProviderBuilder;
import io.camunda.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.process.test.impl.runtime.properties.RemoteRuntimeClientAuthProperties;
import io.camunda.process.test.impl.runtime.properties.RemoteRuntimeClientProperties;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CptCredentialsProviderConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(CptCredentialsProviderConfigurer.class);
    private static final Map<RemoteRuntimeClientAuthProperties.AuthMethod, Function<RemoteRuntimeClientProperties, CredentialsProvider>> PROVIDERS = new HashMap<RemoteRuntimeClientAuthProperties.AuthMethod, Function<RemoteRuntimeClientProperties, CredentialsProvider>>();

    public static CredentialsProvider configure(RemoteRuntimeClientProperties clientProperties) {
        RemoteRuntimeClientAuthProperties.AuthMethod authMethod = clientProperties.getAuthProperties().getMethod();
        return PROVIDERS.getOrDefault((Object)authMethod, cp -> new NoopCredentialsProvider()).apply(clientProperties);
    }

    private static CredentialsProvider buildBasicAuthCredentialsProvider(RemoteRuntimeClientProperties clientProperties) {
        String username = clientProperties.getAuthProperties().getUsername();
        String password = clientProperties.getAuthProperties().getPassword();
        BasicAuthCredentialsProviderBuilder builder = new BasicAuthCredentialsProviderBuilder().applyEnvironmentOverrides(false).username(username).password(password);
        return CptCredentialsProviderConfigurer.build(() -> ((BasicAuthCredentialsProviderBuilder)builder).build(), "basic");
    }

    private static CredentialsProvider buildOAuthCredentialsProvider(RemoteRuntimeClientProperties clientProperties) {
        OAuthCredentialsProviderBuilder credBuilder = CredentialsProvider.newCredentialsProviderBuilder().applyEnvironmentOverrides(false).clientId(clientProperties.getAuthProperties().getClientId()).clientSecret(clientProperties.getAuthProperties().getClientSecret()).audience(clientProperties.getAuthProperties().getAudience()).scope(clientProperties.getAuthProperties().getScope()).resource(clientProperties.getAuthProperties().getResource()).authorizationServerUrl((String)Optional.ofNullable(clientProperties.getAuthProperties().getTokenUrl()).map(URI::toString).orElse(null)).credentialsCachePath(clientProperties.getAuthProperties().getCredentialsCachePath()).connectTimeout(clientProperties.getAuthProperties().getConnectTimeout()).readTimeout(clientProperties.getAuthProperties().getReadTimeout()).clientAssertionKeystorePath(clientProperties.getAuthProperties().getClientAssertionKeystorePath()).clientAssertionKeystorePassword(clientProperties.getAuthProperties().getClientAssertionKeystorePassword()).clientAssertionKeystoreKeyAlias(clientProperties.getAuthProperties().getClientAssertionKeystoreKeyAlias()).clientAssertionKeystoreKeyPassword(clientProperties.getAuthProperties().getClientAssertionKeystoreKeyPassword());
        CptCredentialsProviderConfigurer.maybeConfigureIdentityProviderSSLConfig(credBuilder, clientProperties);
        return CptCredentialsProviderConfigurer.build(() -> ((OAuthCredentialsProviderBuilder)credBuilder).build(), "oidc");
    }

    private static CredentialsProvider build(Supplier<CredentialsProvider> builder, String providerName) {
        try {
            return builder.get();
        }
        catch (Exception e) {
            LOG.warn("Failed to configure {} credential provider, falling back to no authentication. Cause: {}", (Object)providerName, (Object)e.getMessage());
            LOG.debug("Detailed error:", (Throwable)e);
            return new NoopCredentialsProvider();
        }
    }

    private static void maybeConfigureIdentityProviderSSLConfig(OAuthCredentialsProviderBuilder builder, RemoteRuntimeClientProperties clientProperties) {
        RemoteRuntimeClientAuthProperties auth = clientProperties.getAuthProperties();
        CptCredentialsProviderConfigurer.configureStore(auth.getKeystorePath(), arg_0 -> ((OAuthCredentialsProviderBuilder)builder).keystorePath(arg_0), arg_0 -> ((OAuthCredentialsProviderBuilder)builder).keystorePassword(arg_0), auth.getKeystorePassword(), "keystore");
        CptCredentialsProviderConfigurer.configureStore(auth.getTruststorePath(), arg_0 -> ((OAuthCredentialsProviderBuilder)builder).truststorePath(arg_0), arg_0 -> ((OAuthCredentialsProviderBuilder)builder).truststorePassword(arg_0), auth.getTruststorePassword(), "truststore");
        if (auth.getKeystorePath() != null) {
            builder.keystoreKeyPassword(auth.getKeystoreKeyPassword());
        }
    }

    private static void configureStore(Path path, Consumer<Path> pathSetter, Consumer<String> passwordSetter, String password, String label) {
        if (path != null) {
            if (Files.exists(path, new LinkOption[0])) {
                LOG.debug("Using {} {}", (Object)label, (Object)path);
                pathSetter.accept(path);
                passwordSetter.accept(password);
            } else {
                LOG.debug("{} {} not found", (Object)label, (Object)path);
            }
        }
    }

    static {
        PROVIDERS.put(RemoteRuntimeClientAuthProperties.AuthMethod.basic, CptCredentialsProviderConfigurer::buildBasicAuthCredentialsProvider);
        PROVIDERS.put(RemoteRuntimeClientAuthProperties.AuthMethod.oidc, CptCredentialsProviderConfigurer::buildOAuthCredentialsProvider);
        PROVIDERS.put(RemoteRuntimeClientAuthProperties.AuthMethod.none, cp -> new NoopCredentialsProvider());
    }
}

