/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.constraint;

import io.camunda.shaded.awaitility.constraint.IntervalWaitConstraint;
import io.camunda.shaded.awaitility.constraint.WaitConstraint;
import java.time.Duration;

public class HoldsPredicateWaitConstraint
extends IntervalWaitConstraint {
    private final Duration holdConditionTime;

    HoldsPredicateWaitConstraint(Duration atLeastConstraint, Duration atMostDuration, Duration holdConditionTime) {
        super(atLeastConstraint, atMostDuration);
        this.holdConditionTime = holdConditionTime;
    }

    @Override
    public Duration getHoldPredicateTime() {
        return this.holdConditionTime;
    }

    @Override
    public WaitConstraint withHoldPredicateTime(Duration holdConditionTime) {
        return new HoldsPredicateWaitConstraint(this.getMinWaitTime(), this.getMaxWaitTime(), holdConditionTime);
    }

    @Override
    public WaitConstraint withMaxWaitTime(Duration maxWaitTime) {
        return new HoldsPredicateWaitConstraint(this.getMinWaitTime(), maxWaitTime, this.holdConditionTime);
    }

    @Override
    public WaitConstraint withMinWaitTime(Duration minWaitTime) {
        return new HoldsPredicateWaitConstraint(minWaitTime, this.getMaxWaitTime(), this.holdConditionTime);
    }
}

