/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.core;

import io.camunda.shaded.awaitility.core.Condition;
import io.camunda.shaded.awaitility.core.ConditionAwaiter;
import io.camunda.shaded.awaitility.core.ConditionEvaluationHandler;
import io.camunda.shaded.awaitility.core.ConditionEvaluationResult;
import io.camunda.shaded.awaitility.core.ConditionEvaluator;
import io.camunda.shaded.awaitility.core.ConditionSettings;
import io.camunda.shaded.awaitility.core.HamcrestToStringFilter;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public abstract class AbstractHamcrestCondition<T>
implements Condition<T> {
    private ConditionAwaiter conditionAwaiter;
    private volatile T lastResult;
    private final ConditionEvaluationHandler<T> conditionEvaluationHandler;

    protected AbstractHamcrestCondition(final Callable<T> supplier, final Matcher<? super T> matcher, ConditionSettings settings) {
        if (supplier == null) {
            throw new IllegalArgumentException("You must specify a supplier (was null).");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("You must specify a matcher (was null).");
        }
        this.conditionEvaluationHandler = new ConditionEvaluationHandler<T>(matcher, settings);
        ConditionEvaluator callable = pollInterval -> {
            this.lastResult = supplier.call();
            boolean matches = matcher.matches(this.lastResult);
            if (matches) {
                this.conditionEvaluationHandler.handleConditionResultMatch(this.getMatchMessage(supplier, matcher), this.lastResult, pollInterval);
            } else {
                this.conditionEvaluationHandler.handleConditionResultMismatch(this.getMismatchMessage(supplier, matcher), this.lastResult, pollInterval);
            }
            return new ConditionEvaluationResult(matches);
        };
        this.conditionAwaiter = new ConditionAwaiter(callable, settings){

            @Override
            protected String getTimeoutMessage() {
                return AbstractHamcrestCondition.this.getMismatchMessage(supplier, matcher);
            }
        };
    }

    private String getMatchMessage(Callable<T> supplier, Matcher<? super T> matcher) {
        return String.format("%s reached its end value of %s", this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher));
    }

    private String getMismatchMessage(Callable<T> supplier, Matcher<? super T> matcher) {
        StringDescription mismatchDescription = new StringDescription();
        matcher.describeMismatch(this.lastResult, (Description)mismatchDescription);
        if (mismatchDescription.toString() != null && mismatchDescription.toString().isEmpty()) {
            mismatchDescription.appendText("was ").appendValue(this.lastResult);
        }
        return String.format("%s expected %s but %s", this.getCallableDescription(supplier), HamcrestToStringFilter.filter(matcher), mismatchDescription);
    }

    @Override
    public T await() {
        this.conditionAwaiter.await(this.conditionEvaluationHandler);
        return this.lastResult;
    }

    protected abstract String getCallableDescription(Callable<T> var1);
}

