/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.core;

import io.camunda.shaded.awaitility.core.Condition;
import io.camunda.shaded.awaitility.core.ConditionAwaiter;
import io.camunda.shaded.awaitility.core.ConditionEvaluationHandler;
import io.camunda.shaded.awaitility.core.ConditionEvaluationResult;
import io.camunda.shaded.awaitility.core.ConditionEvaluator;
import io.camunda.shaded.awaitility.core.ConditionSettings;
import io.camunda.shaded.awaitility.core.LambdaErrorMessageGenerator;
import io.camunda.shaded.awaitility.spi.Timeout;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.Callable;

class CallableCondition
implements Condition<Void> {
    private final ConditionAwaiter conditionAwaiter;
    private final ConditionEvaluationHandler<Object> conditionEvaluationHandler;

    CallableCondition(final Callable<Boolean> matcher, ConditionSettings settings) {
        this.conditionEvaluationHandler = new ConditionEvaluationHandler(null, settings);
        ConditionEvaluationWrapper conditionEvaluationWrapper = new ConditionEvaluationWrapper(matcher, settings, this.conditionEvaluationHandler);
        this.conditionAwaiter = new ConditionAwaiter(conditionEvaluationWrapper, settings){

            @Override
            protected String getTimeoutMessage() {
                String timeoutMessage;
                if (Timeout.timeout_message != null) {
                    return Timeout.timeout_message;
                }
                if (matcher == null) {
                    timeoutMessage = "";
                } else {
                    Class<?> type = matcher.getClass();
                    Method enclosingMethod = type.getEnclosingMethod();
                    if (type.isAnonymousClass() && enclosingMethod != null) {
                        timeoutMessage = String.format("Condition returned by method \"%s\" in class %s was not fulfilled", enclosingMethod.getName(), enclosingMethod.getDeclaringClass().getName());
                    } else {
                        String message = LambdaErrorMessageGenerator.isLambdaClass(type) ? "with " + LambdaErrorMessageGenerator.generateLambdaErrorMessagePrefix(type, false) : type.getName();
                        timeoutMessage = String.format("Condition %s was not fulfilled", message);
                    }
                }
                return timeoutMessage;
            }
        };
    }

    @Override
    public Void await() {
        this.conditionAwaiter.await(this.conditionEvaluationHandler);
        return null;
    }

    private static class ConditionEvaluationWrapper
    implements ConditionEvaluator {
        private final Callable<Boolean> matcher;
        private final ConditionSettings settings;
        private final ConditionEvaluationHandler<Object> conditionEvaluationHandler;

        ConditionEvaluationWrapper(Callable<Boolean> matcher, ConditionSettings settings, ConditionEvaluationHandler<Object> conditionEvaluationHandler) {
            this.matcher = matcher;
            this.settings = settings;
            this.conditionEvaluationHandler = conditionEvaluationHandler;
        }

        @Override
        public ConditionEvaluationResult eval(Duration pollInterval) throws Exception {
            boolean conditionFulfilled = this.matcher.call();
            if (conditionFulfilled) {
                this.conditionEvaluationHandler.handleConditionResultMatch(this.getMatchMessage(this.matcher, this.settings.getAlias()), true, pollInterval);
            } else {
                this.conditionEvaluationHandler.handleConditionResultMismatch(this.getMismatchMessage(this.matcher, this.settings.getAlias()), false, pollInterval);
            }
            return new ConditionEvaluationResult(conditionFulfilled);
        }

        private String getMatchMessage(Callable<Boolean> matcher, String conditionAlias) {
            return this.generateDescriptionPrefix(matcher, conditionAlias) + " returned true";
        }

        private String getMismatchMessage(Callable<Boolean> matcher, String conditionAlias) {
            return this.generateDescriptionPrefix(matcher, conditionAlias) + " returned false";
        }

        private String generateDescriptionPrefix(Callable<Boolean> matcher, String conditionAlias) {
            boolean hasAlias;
            String methodDescription = this.generateMethodDescription(matcher);
            boolean bl = hasAlias = conditionAlias != null;
            if (LambdaErrorMessageGenerator.isLambdaClass(matcher.getClass())) {
                String prefix = hasAlias ? "Condition with alias " + conditionAlias + " defined as a " : "Condition defined as a ";
                return prefix + LambdaErrorMessageGenerator.generateLambdaErrorMessagePrefix(matcher.getClass(), false) + methodDescription;
            }
            return "Callable condition" + (hasAlias ? " with alias " + conditionAlias : "") + methodDescription;
        }

        private String generateMethodDescription(Callable<Boolean> matcher) {
            String methodDescription = "";
            Method enclosingMethod = matcher.getClass().getEnclosingMethod();
            if (enclosingMethod != null) {
                methodDescription = " defined in " + enclosingMethod.toString();
            }
            return methodDescription;
        }
    }
}

