/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.core;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

public class DurationFactory {
    public static Duration of(long amount, TimeUnit timeUnit) {
        ChronoUnit chronoUnit;
        switch (timeUnit) {
            case NANOSECONDS: {
                chronoUnit = ChronoUnit.NANOS;
                break;
            }
            case MICROSECONDS: {
                chronoUnit = ChronoUnit.MICROS;
                break;
            }
            case MILLISECONDS: {
                chronoUnit = ChronoUnit.MILLIS;
                break;
            }
            case SECONDS: {
                chronoUnit = ChronoUnit.SECONDS;
                break;
            }
            case MINUTES: {
                chronoUnit = ChronoUnit.MINUTES;
                break;
            }
            case HOURS: {
                chronoUnit = ChronoUnit.HOURS;
                break;
            }
            case DAYS: {
                chronoUnit = ChronoUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalStateException("Cannot convert " + TimeUnit.class.getSimpleName() + " to a " + ChronoUnit.class.getSimpleName());
            }
        }
        Duration duration = Duration.of(amount, chronoUnit);
        DurationFactory.checkThatDurationCanBeConvertedToNanos(duration, amount, timeUnit);
        return duration;
    }

    private static void checkThatDurationCanBeConvertedToNanos(Duration timeout, long amount, TimeUnit timeUnit) {
        try {
            timeout.toNanos();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s %s to nanoseconds, as required by Awaitility, because this value is too large", new Object[]{amount, timeUnit}), e);
        }
    }
}

