/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.core;

import io.camunda.shaded.awaitility.core.SameThreadExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InternalExecutorServiceFactory {
    public static ExecutorService sameThreadExecutorService() {
        return new SameThreadExecutorService();
    }

    public static ExecutorService create(Function<Runnable, Thread> threadSupplier) {
        if (threadSupplier == null) {
            throw new IllegalArgumentException("Condition evaluation thread supplier cannot be null");
        }
        return InternalExecutorServiceFactory.create((runnable, __) -> (Thread)threadSupplier.apply((Runnable)runnable), null);
    }

    public static ExecutorService create(BiFunction<Runnable, String, Thread> threadSupplier, String alias) {
        if (threadSupplier == null) {
            throw new IllegalArgumentException("Condition evaluation thread supplier cannot be null");
        }
        return Executors.newSingleThreadExecutor(r -> {
            String threadName = InternalExecutorServiceFactory.generateDefaultThreadName(alias);
            return (Thread)threadSupplier.apply(r, threadName);
        });
    }

    private static String generateDefaultThreadName(String alias) {
        return alias == null ? "awaitility-thread" : "awaitility[" + alias + "]";
    }
}

