/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.core;

import io.camunda.shaded.awaitility.core.JavaVersionDetector;
import java.lang.reflect.Method;

class LambdaErrorMessageGenerator {
    private static final String BEFORE_JAVA_21_LAMBDA_CLASS_NAME = "$$Lambda$";
    private static final String JAVA_21_LAMBDA_CLASS_NAME = "$$Lambda/";
    private static final String LAMBDA_METHOD_NAME = "$Lambda";

    LambdaErrorMessageGenerator() {
    }

    static boolean isLambdaClass(Class<?> cls) {
        String lambdaDetectionClassName = LambdaErrorMessageGenerator.getLambdaDetectionClassName();
        return cls.getSimpleName().contains(lambdaDetectionClassName);
    }

    static String generateLambdaErrorMessagePrefix(Class<?> lambdaClass, boolean firstLetterLowerCaseAndEndWithColon) {
        String name = lambdaClass.getName();
        String lambdaDetectionClassName = LambdaErrorMessageGenerator.getLambdaDetectionClassName();
        int indexOfLambda = name.indexOf(lambdaDetectionClassName);
        String nameWithoutLambda = name.substring(0, indexOfLambda);
        nameWithoutLambda = LambdaErrorMessageGenerator.addLambdaDetailsIfFound(lambdaClass, nameWithoutLambda, firstLetterLowerCaseAndEndWithColon);
        return nameWithoutLambda;
    }

    private static String addLambdaDetailsIfFound(Class<?> supplierClass, String nameWithoutLambda, boolean firstLetterUpperCaseAndEndWithColon) {
        String nameToReturn = nameWithoutLambda;
        Method[] declaredMethods = supplierClass.getDeclaredMethods();
        Method lambdaMethod = null;
        for (Method declaredMethod : declaredMethods) {
            if (!declaredMethod.getName().contains(LAMBDA_METHOD_NAME)) continue;
            lambdaMethod = declaredMethod;
            break;
        }
        if (lambdaMethod == null) {
            nameToReturn = "Lambda expression in " + nameWithoutLambda;
        } else {
            Class<?>[] lambdaParams = lambdaMethod.getParameterTypes();
            if (lambdaParams.length > 0) {
                StringBuilder nameToReturnBuilder = new StringBuilder(firstLetterUpperCaseAndEndWithColon ? "L" : "l").append("ambda expression in ").append(nameToReturn);
                if (nameWithoutLambda.equals(lambdaParams[0].getName())) {
                    if (firstLetterUpperCaseAndEndWithColon) {
                        nameToReturnBuilder.append(':');
                    }
                } else {
                    nameToReturnBuilder.append(" that uses ");
                    for (int i = 0; i < lambdaParams.length; ++i) {
                        Class<?> lambdaParam = lambdaParams[i];
                        nameToReturnBuilder.append(lambdaParam.getName());
                        if (i + 1 == lambdaParams.length) {
                            if (!firstLetterUpperCaseAndEndWithColon) continue;
                            nameToReturnBuilder.append(':');
                            continue;
                        }
                        nameToReturnBuilder.append(", ").append(lambdaParam.getName());
                    }
                }
                nameToReturn = nameToReturnBuilder.toString();
            }
        }
        return nameToReturn;
    }

    private static String getLambdaDetectionClassName() {
        int javaVersion = JavaVersionDetector.getJavaMajorVersion();
        if (javaVersion >= 21) {
            return JAVA_21_LAMBDA_CLASS_NAME;
        }
        return BEFORE_JAVA_21_LAMBDA_CLASS_NAME;
    }
}

