/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.pollinterval;

import io.camunda.shaded.awaitility.core.ForeverDuration;
import io.camunda.shaded.awaitility.pollinterval.PollInterval;
import java.time.Duration;
import java.util.function.Function;

public class IterativePollInterval
implements PollInterval {
    private final Function<Duration, Duration> function;
    private final Duration startDuration;

    public IterativePollInterval(Function<Duration, Duration> function) {
        this(function, null, false);
    }

    public IterativePollInterval(Function<Duration, Duration> function, Duration startDuration) {
        this(function, startDuration, true);
    }

    private IterativePollInterval(Function<Duration, Duration> function, Duration startDuration, boolean startDurationExplicitlyDefined) {
        if (function == null) {
            throw new IllegalArgumentException("Function<Duration, Duration> cannot be null");
        }
        if (startDurationExplicitlyDefined && startDuration == null) {
            throw new IllegalArgumentException("Start duration cannot be null");
        }
        if (startDurationExplicitlyDefined && ForeverDuration.isForever(startDuration)) {
            throw new IllegalArgumentException("Cannot use a poll interval of length 'forever'");
        }
        this.function = function;
        this.startDuration = startDuration;
    }

    @Override
    public Duration next(int pollCount, Duration previousDuration) {
        Duration durationToUse = pollCount == 1 && this.startDuration != null ? this.startDuration : previousDuration;
        return this.function.apply(durationToUse);
    }

    public static IterativePollInterval iterative(Function<Duration, Duration> function) {
        return new IterativePollInterval(function);
    }

    public static IterativePollInterval iterative(Function<Duration, Duration> function, Duration startDuration) {
        return new IterativePollInterval(function, startDuration);
    }

    public IterativePollInterval with() {
        return this;
    }

    public IterativePollInterval startDuration(Duration duration) {
        return new IterativePollInterval(this.function, duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IterativePollInterval)) {
            return false;
        }
        IterativePollInterval that = (IterativePollInterval)o;
        return this.function.equals(that.function) && this.startDuration.equals(that.startDuration);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.startDuration.hashCode();
        return result;
    }

    public String toString() {
        return "IterativePollInterval{function=" + this.function + ", startDuration=" + this.startDuration + '}';
    }
}

