/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.shaded.awaitility.reflect;

import io.camunda.shaded.awaitility.reflect.FieldMatcherStrategy;
import io.camunda.shaded.awaitility.reflect.exception.FieldNotFoundException;
import java.lang.reflect.Field;

class FieldNameMatcherStrategy
extends FieldMatcherStrategy {
    private final String fieldName;

    public FieldNameMatcherStrategy(String fieldName) {
        if (fieldName == null || fieldName.equals("") || fieldName.startsWith(" ")) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        this.fieldName = fieldName;
    }

    @Override
    public boolean matches(Field field) {
        return this.fieldName.equals(field.getName());
    }

    @Override
    public void notFound(Class<?> type, boolean isInstanceField) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field named \"%s\" could be found in the class hierarchy of %s.", isInstanceField ? "instance" : "static", this.fieldName, type.getName()));
    }

    public String toString() {
        return "fieldName " + this.fieldName;
    }
}

