/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> List<T> addValuesToList(List<T> list, List<T> values) {
        List<T> result;
        if (list == null) {
            result = Objects.requireNonNull(values);
        } else {
            result = new ArrayList<T>(list);
            result.addAll(values);
        }
        return result;
    }

    public static <T> List<T> toList(T ... values) {
        ArrayList<T> collectedValues = new ArrayList<T>();
        if (values != null && values.length > 0) {
            collectedValues.addAll(Arrays.asList(values));
        }
        return collectedValues;
    }
}

