package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSINodeListBuilder extends CSINodeListFluentImpl<CSINodeListBuilder> implements VisitableBuilder<CSINodeList,CSINodeListBuilder> {

    CSINodeListFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeListBuilder() { 
        this(true);
    }


    public CSINodeListBuilder(Boolean validationEnabled) { 
        this(new CSINodeList(), validationEnabled);
    }


    public CSINodeListBuilder(CSINodeListFluent<?> fluent) { 
        this(fluent, true);
    }


    public CSINodeListBuilder(CSINodeListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CSINodeList(), validationEnabled);
    }


    public CSINodeListBuilder(CSINodeListFluent<?> fluent,CSINodeList instance) { 
        this(fluent, instance, true);
    }


    public CSINodeListBuilder(CSINodeListFluent<?> fluent,CSINodeList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public CSINodeListBuilder(CSINodeList instance) { 
        this(instance,true);
    }


    public CSINodeListBuilder(CSINodeList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public CSINodeList build() {
        CSINodeList buildable = new CSINodeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSINodeListBuilder that = (CSINodeListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
