package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CSIDriverListFluent<A extends CSIDriverListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,CSIDriver item);
    public A setToItems(int index,CSIDriver item);
    public A addToItems(CSIDriver... items);
    public A addAllToItems(Collection<CSIDriver> items);
    public A removeFromItems(CSIDriver... items);
    public A removeAllFromItems(Collection<CSIDriver> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<CSIDriverBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CSIDriver> getItems();
    public List<CSIDriver> buildItems();
    public CSIDriver buildItem(int index);
    public CSIDriver buildFirstItem();
    public CSIDriver buildLastItem();
    public CSIDriver buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CSIDriverBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CSIDriverBuilder> predicate);
    public A withItems(List<CSIDriver> items);
    public A withItems(CSIDriver... items);
    public Boolean hasItems();
    public CSIDriverListFluent.ItemsNested<A> addNewItem();
    public CSIDriverListFluent.ItemsNested<A> addNewItemLike(CSIDriver item);
    public CSIDriverListFluent.ItemsNested<A> setNewItemLike(int index,CSIDriver item);
    public CSIDriverListFluent.ItemsNested<A> editItem(int index);
    public CSIDriverListFluent.ItemsNested<A> editFirstItem();
    public CSIDriverListFluent.ItemsNested<A> editLastItem();
    public CSIDriverListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CSIDriverBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSIDriverFluent<CSIDriverListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
