package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class HorizontalPodAutoscalerStatusFluentImpl<A extends HorizontalPodAutoscalerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HorizontalPodAutoscalerStatusFluent<A>{

    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private String lastScaleTime;
    private Long observedGeneration;

    public HorizontalPodAutoscalerStatusFluentImpl(){
    }
    public HorizontalPodAutoscalerStatusFluentImpl(HorizontalPodAutoscalerStatus instance){
            this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); 
            this.withCurrentReplicas(instance.getCurrentReplicas()); 
            this.withDesiredReplicas(instance.getDesiredReplicas()); 
            this.withLastScaleTime(instance.getLastScaleTime()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
    }

    public Integer getCurrentCPUUtilizationPercentage(){
            return this.currentCPUUtilizationPercentage;
    }

    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage){
            this.currentCPUUtilizationPercentage=currentCPUUtilizationPercentage; return (A) this;
    }

    public Boolean hasCurrentCPUUtilizationPercentage(){
            return this.currentCPUUtilizationPercentage != null;
    }

    public Integer getCurrentReplicas(){
            return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas){
            this.currentReplicas=currentReplicas; return (A) this;
    }

    public Boolean hasCurrentReplicas(){
            return this.currentReplicas != null;
    }

    public Integer getDesiredReplicas(){
            return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas){
            this.desiredReplicas=desiredReplicas; return (A) this;
    }

    public Boolean hasDesiredReplicas(){
            return this.desiredReplicas != null;
    }

    public String getLastScaleTime(){
            return this.lastScaleTime;
    }

    public A withLastScaleTime(String lastScaleTime){
            this.lastScaleTime=lastScaleTime; return (A) this;
    }

    public Boolean hasLastScaleTime(){
            return this.lastScaleTime != null;
    }

    public A withNewLastScaleTime(String arg1){
            return (A)withLastScaleTime(new String(arg1));
    }

    public A withNewLastScaleTime(StringBuilder arg1){
            return (A)withLastScaleTime(new String(arg1));
    }

    public A withNewLastScaleTime(StringBuffer arg1){
            return (A)withLastScaleTime(new String(arg1));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl) o;
            if (currentCPUUtilizationPercentage != null ? !currentCPUUtilizationPercentage.equals(that.currentCPUUtilizationPercentage) :that.currentCPUUtilizationPercentage != null) return false;
            if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
            if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
            if (lastScaleTime != null ? !lastScaleTime.equals(that.lastScaleTime) :that.lastScaleTime != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            return true;
    }




}
