package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NamespaceFluent<A extends NamespaceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public NamespaceFluent.MetadataNested<A> withNewMetadata();
    public NamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NamespaceFluent.MetadataNested<A> editMetadata();
    public NamespaceFluent.MetadataNested<A> editOrNewMetadata();
    public NamespaceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceSpec getSpec();
    public NamespaceSpec buildSpec();
    public A withSpec(NamespaceSpec spec);
    public Boolean hasSpec();
    public NamespaceFluent.SpecNested<A> withNewSpec();
    public NamespaceFluent.SpecNested<A> withNewSpecLike(NamespaceSpec item);
    public NamespaceFluent.SpecNested<A> editSpec();
    public NamespaceFluent.SpecNested<A> editOrNewSpec();
    public NamespaceFluent.SpecNested<A> editOrNewSpecLike(NamespaceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceStatus getStatus();
    public NamespaceStatus buildStatus();
    public A withStatus(NamespaceStatus status);
    public Boolean hasStatus();
    public A withNewStatus(String phase);
    public NamespaceFluent.StatusNested<A> withNewStatus();
    public NamespaceFluent.StatusNested<A> withNewStatusLike(NamespaceStatus item);
    public NamespaceFluent.StatusNested<A> editStatus();
    public NamespaceFluent.StatusNested<A> editOrNewStatus();
    public NamespaceFluent.StatusNested<A> editOrNewStatusLike(NamespaceStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<NamespaceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceSpecFluent<NamespaceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceStatusFluent<NamespaceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
