
package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "allowedRuntimeClassNames",
    "defaultRuntimeClassName"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class RuntimeClassStrategyOptions implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("allowedRuntimeClassNames")
    private List<String> allowedRuntimeClassNames = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("defaultRuntimeClassName")
    private String defaultRuntimeClassName;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public RuntimeClassStrategyOptions() {
    }

    /**
     * 
     * @param allowedRuntimeClassNames
     * @param defaultRuntimeClassName
     */
    public RuntimeClassStrategyOptions(List<String> allowedRuntimeClassNames, String defaultRuntimeClassName) {
        this.allowedRuntimeClassNames = allowedRuntimeClassNames;
        this.defaultRuntimeClassName = defaultRuntimeClassName;
    }

    /**
     * 
     * 
     * @return
     *     The allowedRuntimeClassNames
     */
    @JsonProperty("allowedRuntimeClassNames")
    public List<String> getAllowedRuntimeClassNames() {
        return allowedRuntimeClassNames;
    }

    /**
     * 
     * 
     * @param allowedRuntimeClassNames
     *     The allowedRuntimeClassNames
     */
    @JsonProperty("allowedRuntimeClassNames")
    public void setAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
        this.allowedRuntimeClassNames = allowedRuntimeClassNames;
    }

    /**
     * 
     * 
     * @return
     *     The defaultRuntimeClassName
     */
    @JsonProperty("defaultRuntimeClassName")
    public String getDefaultRuntimeClassName() {
        return defaultRuntimeClassName;
    }

    /**
     * 
     * 
     * @param defaultRuntimeClassName
     *     The defaultRuntimeClassName
     */
    @JsonProperty("defaultRuntimeClassName")
    public void setDefaultRuntimeClassName(String defaultRuntimeClassName) {
        this.defaultRuntimeClassName = defaultRuntimeClassName;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
