/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import io.gatling.plugin.EmptyChoicesException;
import io.gatling.plugin.InteractiveEnterprisePlugin;
import io.gatling.plugin.PluginClient;
import io.gatling.plugin.Show;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidSimulationClassException;
import io.gatling.plugin.exceptions.NoSimulationClassNameFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.exceptions.UserQuitException;
import io.gatling.plugin.io.PluginIO;
import io.gatling.plugin.io.input.InputChoice;
import io.gatling.plugin.model.HostByLocation;
import io.gatling.plugin.model.Location;
import io.gatling.plugin.model.Pkg;
import io.gatling.plugin.model.PkgIndex;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.model.Team;
import io.gatling.plugin.util.LambdaExceptionUtil;
import io.gatling.plugin.util.ObjectsUtil;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class InteractiveEnterprisePluginClient
extends PluginClient
implements InteractiveEnterprisePlugin {
    private final InputChoice inputChoice;
    private static final int DEFAULT_HOST_WEIGHT = 100;

    public InteractiveEnterprisePluginClient(EnterpriseClient enterpriseClient, PluginIO pluginIO) {
        super(enterpriseClient, pluginIO.getLogger());
        this.inputChoice = new InputChoice(pluginIO);
    }

    @Override
    public SimulationStartResult uploadPackageAndStartSimulation(UUID uUID, Map<String, String> map, Map<String, String> map2, String string, File file) throws EnterprisePluginException {
        ObjectsUtil.nonNullParam(uUID, "simulationId");
        ObjectsUtil.nonNullParam(map, "systemProperties");
        ObjectsUtil.nonNullParam(map2, "environmentVariables");
        ObjectsUtil.nonNullParam(file, "file");
        Simulation simulation = this.enterpriseClient.getSimulation(uUID);
        List<String> list = this.simulationClassesFromCompatibleByteCodeFile(file);
        this.uploadPackageWithChecksum(simulation.pkgId, file);
        return this.launchSimulation(simulation, map, map2, string, list);
    }

    @Override
    public SimulationStartResult createAndStartSimulation(UUID uUID, String string, String string2, String string3, UUID uUID2, Map<String, String> map, Map<String, String> map2, File file) throws EnterprisePluginException {
        boolean bl;
        ObjectsUtil.nonNullParam(map, "systemProperties");
        ObjectsUtil.nonNullParam(map2, "environmentVariables");
        ObjectsUtil.nonNullParam(file, "file");
        List<String> list = this.simulationClassesFromCompatibleByteCodeFile(file);
        List<Simulation> list2 = this.enterpriseClient.getSimulations();
        boolean bl2 = bl = list2.isEmpty() || this.chooseIfCreateSimulation();
        if (bl) {
            return this.createAndStart(uUID, string, string2, string3, list, uUID2, file, list2, map, map2);
        }
        if (list2.isEmpty()) {
            throw new EmptyChoicesException("simulations");
        }
        Simulation simulation2 = this.inputChoice.inputFromList(list2, Show::simulation, Comparator.comparing(simulation -> simulation.name));
        return this.startSimulation(simulation2, file, map, map2, string3, list);
    }

    private boolean chooseIfCreateSimulation() throws UserQuitException {
        this.logger.info("Do you want to create a new simulation or start an existing one?");
        List<String> list = Arrays.asList("Create a new Simulation on Gatling Enterprise, then start it", "Start an existing Simulation on Gatling Enterprise");
        return this.inputChoice.inputFromStringList(list, false).equals("Create a new Simulation on Gatling Enterprise, then start it");
    }

    private SimulationStartResult startSimulation(Simulation simulation, File file, Map<String, String> map, Map<String, String> map2, String string, List<String> list) throws EnterprisePluginException, EmptyChoicesException {
        this.logger.info("Proceeding to start simulation " + simulation.name);
        this.uploadPackageWithChecksum(simulation.pkgId, file);
        return this.launchSimulation(simulation, map, map2, string, list);
    }

    private SimulationStartResult launchSimulation(Simulation simulation, Map<String, String> map, Map<String, String> map2, String string, List<String> list) throws EnterprisePluginException {
        String string2 = this.chooseClassName(simulation, string, list);
        if (!simulation.className.equals(string2)) {
            this.logger.info("Update simulation class name to configured value " + string2);
            this.enterpriseClient.updateSimulationClassName(simulation.id, string2);
        }
        return this.startSimulation(simulation, map, map2, string2, false);
    }

    private SimulationStartResult createAndStart(UUID uUID, String string, String string2, String string3, List<String> list, UUID uUID2, File file, List<Simulation> list2, Map<String, String> map, Map<String, String> map2) throws EnterprisePluginException, EmptyChoicesException {
        this.logger.info("Proceeding to the create simulation step");
        String string4 = this.chooseClassName(null, string3, list);
        Team team = this.chooseTeam(uUID);
        String string5 = this.chooseSimulationName(string4, list2);
        Pkg pkg = this.chooseOrCreatePackage(team.id, string, string2, uUID2);
        Location location = this.chooseLocation();
        int n = this.chooseSize();
        this.uploadPackageWithChecksum(pkg.id, file);
        Map<UUID, HostByLocation> map3 = Collections.singletonMap(location.id, new HostByLocation(n, 100));
        Simulation simulation = this.enterpriseClient.createSimulation(string5, team.id, string4, pkg.id, map3);
        return this.startSimulation(simulation, map, map2, string4, true);
    }

    private SimulationStartResult startSimulation(Simulation simulation, Map<String, String> map, Map<String, String> map2, String string, boolean bl) throws SimulationStartException {
        try {
            this.logger.info("Start simulation using simulation class name: " + string);
            RunSummary runSummary = this.enterpriseClient.startSimulation(simulation.id, map, map2);
            return new SimulationStartResult(simulation, runSummary, bl);
        }
        catch (EnterprisePluginException enterprisePluginException) {
            throw new SimulationStartException(simulation, bl, enterprisePluginException);
        }
    }

    private Team chooseTeam(UUID uUID) throws EnterprisePluginException, EmptyChoicesException {
        List<Team> list = this.enterpriseClient.getTeams();
        if (uUID != null) {
            Team team2 = list.stream().filter(team -> team.id.equals(uUID)).findFirst().orElseThrow(() -> new IllegalStateException("Configured team ID " + uUID + " was not found"));
            this.logger.info(String.format("Picking the configured team: %s (%s)\n", team2.id, team2.name));
            return team2;
        }
        if (list.isEmpty()) {
            throw new EmptyChoicesException("teams");
        }
        this.logger.info("Choose a team from the list:");
        return this.inputChoice.inputFromList(list, Show::team, Comparator.comparing(team -> team.name));
    }

    private static String simulationNameFromClassName(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1];
    }

    private String chooseSimulationName(String string2, List<Simulation> list) {
        String string3 = InteractiveEnterprisePluginClient.simulationNameFromClassName(string2);
        List list2 = list.stream().map(simulation -> simulation.name).collect(Collectors.toList());
        LambdaExceptionUtil.ConsumerWithExceptions<String, IllegalArgumentException> consumerWithExceptions = string -> {
            if (string.isEmpty()) {
                throw new IllegalArgumentException("The simulation name should not be empty");
            }
            if (list2.contains(string)) {
                throw new IllegalArgumentException("A simulation named " + string + " already exists");
            }
        };
        if (!list2.contains(string3)) {
            this.logger.info("Enter a simulation name, or just hit enter to accept the default name (" + string3 + ")");
            return this.inputChoice.inputStringWithDefault(string3, consumerWithExceptions);
        }
        this.logger.info("Enter a simulation name");
        return this.inputChoice.inputString(consumerWithExceptions);
    }

    private Pkg chooseOrCreatePackage(UUID uUID, String string, String string2, UUID uUID2) throws EnterprisePluginException {
        List<PkgIndex> list = this.enterpriseClient.getPackages();
        if (uUID2 != null) {
            UUID uUID3 = list.stream().filter(pkgIndex -> pkgIndex.id.equals(uUID2)).map(pkgIndex -> pkgIndex.id).findFirst().orElseThrow(() -> new IllegalStateException("Configured package ID " + uUID2 + " was not found"));
            return this.enterpriseClient.getPackage(uUID3);
        }
        boolean bl = list.isEmpty() || this.chooseIfCreatePackage();
        return bl ? this.createPackage(uUID, string, string2, list) : this.choosePackage(list);
    }

    private boolean chooseIfCreatePackage() throws UserQuitException {
        this.logger.info("Do you want to create a new package or upload your project to an existing one?");
        List<String> list = Arrays.asList("Create a new package on Gatling Enterprise", "Choose an existing package on Gatling Enterprise");
        return this.inputChoice.inputFromStringList(list, false).equals("Create a new package on Gatling Enterprise");
    }

    private Pkg choosePackage(List<PkgIndex> list) throws EnterprisePluginException {
        this.logger.info("Choose a package from the list:");
        UUID uUID = this.inputChoice.inputFromList(list, (Function<PkgIndex, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, packageIndex(io.gatling.plugin.model.PkgIndex ), (Lio/gatling/plugin/model/PkgIndex;)Ljava/lang/String;)(), Comparator.comparing((Function<PkgIndex, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$choosePackage$9(io.gatling.plugin.model.PkgIndex ), (Lio/gatling/plugin/model/PkgIndex;)Ljava/lang/String;)())).id;
        return this.enterpriseClient.getPackage(uUID);
    }

    private Pkg createPackage(UUID uUID, String string2, String string3, List<PkgIndex> list) throws EnterprisePluginException {
        String string4;
        String string5 = string3 != null ? (string2 != null ? string2 + ":" + string3 : string3) : null;
        Set set = list.stream().map(pkgIndex -> pkgIndex.name).collect(Collectors.toSet());
        LambdaExceptionUtil.ConsumerWithExceptions<String, IllegalArgumentException> consumerWithExceptions = string -> {
            if (string.isEmpty()) {
                throw new IllegalArgumentException("The package name should not be empty");
            }
            if (set.contains(string)) {
                throw new IllegalArgumentException("A package named " + string + " already exists");
            }
        };
        if (string5 != null && !set.contains(string5)) {
            this.logger.info("Enter a package name, or just hit enter to accept the default name (" + string5 + ")");
            string4 = this.inputChoice.inputStringWithDefault(string5, consumerWithExceptions);
        } else {
            this.logger.info("Enter a package name");
            string4 = this.inputChoice.inputString(consumerWithExceptions);
        }
        return this.enterpriseClient.createPackage(string4, uUID);
    }

    private Location chooseLocation() throws EnterprisePluginException, EmptyChoicesException {
        List<Location> list = this.enterpriseClient.getLocations();
        if (list.isEmpty()) {
            throw new EmptyChoicesException("locations");
        }
        this.logger.info("Choose the load generators location");
        return this.inputChoice.inputFromList(list, Show::location, Comparator.comparing(location -> location.name));
    }

    private int chooseSize() {
        this.logger.info("Enter the number of load generators");
        return this.inputChoice.inputInt(1);
    }

    private String chooseClassName(Simulation simulation, String string, List<String> list) throws EnterprisePluginException {
        if (list.isEmpty()) {
            throw new NoSimulationClassNameFoundException();
        }
        if (string != null) {
            if (!list.contains(string)) {
                throw new InvalidSimulationClassException(list, string);
            }
            if (simulation.className.equals(string)) {
                return simulation.className;
            }
            return string;
        }
        if (simulation != null && list.contains(simulation.className)) {
            return simulation.className;
        }
        if (simulation != null) {
            this.logger.info("Simulation configured class name '" + simulation.className + "' has not been discovered.");
        }
        this.logger.info("Choose one simulation class in your package:");
        return this.inputChoice.inputFromStringList(list, true);
    }

    private static /* synthetic */ String lambda$choosePackage$9(PkgIndex pkgIndex) {
        return pkgIndex.name;
    }
}

