/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.GatlingMojo;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractGatlingMojo
extends AbstractMojo {
    @Parameter(property="gatling.bodiesFolder", alias="bdf", defaultValue="${basedir}/src/test/resources/bodies")
    protected File bodiesFolder;
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${basedir}/src/test/resources")
    protected File configFolder;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    protected File compiledClassesFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    private RepositorySystem repository;

    protected String buildTestClasspath(boolean includeCompiler) throws Exception {
        ArrayList<String> testClasspathElements = new ArrayList<String>();
        if (!new File(this.compiledClassesFolder, "gatling.conf").exists()) {
            testClasspathElements.add(this.configFolder.getAbsolutePath());
        }
        testClasspathElements.addAll(this.mavenProject.getTestClasspathElements());
        if (includeCompiler) {
            testClasspathElements.add(this.getCompilerJar().getAbsolutePath());
        }
        testClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        return MojoUtils.toMultiPath(testClasspathElements);
    }

    private File getCompilerJar() throws Exception {
        Artifact artifact = this.repository.createArtifact("org.scala-lang", "scala-compiler", "2.11.6", "runtime", "jar");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        request.setServers(this.session.getRequest().getServers());
        request.setMirrors(this.session.getRequest().getMirrors());
        request.setProxies(this.session.getRequest().getProxies());
        request.setLocalRepository(this.session.getLocalRepository());
        request.setRemoteRepositories(this.session.getRequest().getRemoteRepositories());
        this.repository.resolve(request);
        return artifact.getFile();
    }

    protected void addToArgsIfNotNull(List<String> args, Object value, String flag) {
        if (value != null) {
            args.addAll(Arrays.asList("-" + flag, value.toString()));
        }
    }
}

