/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.frodo;

import io.gatling.recorder.internal.bouncycastle.crypto.EncapsulatedSecretExtractor;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.frodo.FrodoKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;

public class FrodoKEMExtractor
implements EncapsulatedSecretExtractor {
    private FrodoEngine engine;
    private FrodoKeyParameters key;

    public FrodoKEMExtractor(FrodoKeyParameters frodoKeyParameters) {
        this.key = frodoKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(FrodoParameters frodoParameters) {
        this.engine = frodoParameters.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getSessionKeySize()];
        this.engine.kem_dec(byArray2, byArray, ((FrodoPrivateKeyParameters)this.key).getPrivateKey());
        return byArray2;
    }

    @Override
    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

