/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.kyber;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.kyber.BCKyberPrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.kyber.BCKyberPublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import io.gatling.recorder.internal.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class KyberKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    KyberKeyGenerationParameters param;
    KyberKeyPairGenerator engine = new KyberKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KyberKeyPairGeneratorSpi() {
        super("Kyber");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = KyberKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new KyberKeyGenerationParameters(secureRandom, (KyberParameters)parameters.get(KyberKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec)));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof KyberParameterSpec) {
            KyberParameterSpec kyberParameterSpec = (KyberParameterSpec)algorithmParameterSpec;
            return kyberParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new KyberKeyGenerationParameters(this.random, KyberParameters.kyber1024);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        KyberPublicKeyParameters kyberPublicKeyParameters = (KyberPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        KyberPrivateKeyParameters kyberPrivateKeyParameters = (KyberPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCKyberPublicKey(kyberPublicKeyParameters), new BCKyberPrivateKey(kyberPrivateKeyParameters));
    }

    static {
        parameters.put(KyberParameterSpec.kyber512.getName(), KyberParameters.kyber512);
        parameters.put(KyberParameterSpec.kyber768.getName(), KyberParameters.kyber768);
        parameters.put(KyberParameterSpec.kyber1024.getName(), KyberParameters.kyber1024);
        parameters.put(KyberParameterSpec.kyber512_aes.getName(), KyberParameters.kyber512_aes);
        parameters.put(KyberParameterSpec.kyber768_aes.getName(), KyberParameters.kyber768_aes);
        parameters.put(KyberParameterSpec.kyber1024_aes.getName(), KyberParameters.kyber1024_aes);
    }
}

