/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiDataSource {
    private static final Logger log = LoggerFactory.getLogger(JndiDataSource.class);

    static DataSource getJndiDatasource(String jndiLookup) {
        InitialContext ctx = null;
        DataSource datasource = null;
        try {
            ctx = new InitialContext();
            datasource = (DataSource)ctx.lookup(jndiLookup);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable e) {
                    log.warn("error closing context", e);
                }
            }
        }
        return datasource;
    }
}

