/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import io.github.biezhi.anima.Anima;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.DefaultResultSetHandlerFactoryBuilder;
import org.sql2o.PojoResultSetIterator;
import org.sql2o.ResultSetHandler;
import org.sql2o.ResultSetHandlerFactory;
import org.sql2o.ResultSetHandlerFactoryBuilder;
import org.sql2o.ResultSetIterable;
import org.sql2o.Sql2oException;
import org.sql2o.converters.Convert;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.data.LazyTable;
import org.sql2o.data.Row;
import org.sql2o.data.Table;
import org.sql2o.data.TableResultSetIterator;
import org.sql2o.quirks.Quirks;

public class Query
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    private Connection connection;
    private Map<String, String> caseSensitiveColumnMappings;
    private Map<String, String> columnMappings;
    private PreparedStatement preparedStatement = null;
    private boolean caseSensitive;
    private boolean autoDeriveColumnNames;
    private boolean throwOnMappingFailure = true;
    private String name;
    private boolean returnGeneratedKeys;
    private final String[] columnNames;
    private String parsedQuery;
    private int maxBatchRecords = 0;
    private int currentBatchRecords = 0;
    private Map<Integer, Object> paramIndexValues = new HashMap<Integer, Object>();
    private ResultSetHandlerFactoryBuilder resultSetHandlerFactoryBuilder;

    public String toString() {
        return this.parsedQuery;
    }

    public Query(Connection connection, String queryText, boolean returnGeneratedKeys) {
        this(connection, queryText, returnGeneratedKeys, null);
    }

    public Query(Connection connection, String queryText, String[] columnNames) {
        this(connection, queryText, false, columnNames);
    }

    private Query(Connection connection, String queryText, boolean returnGeneratedKeys, String[] columnNames) {
        this.connection = connection;
        this.returnGeneratedKeys = returnGeneratedKeys;
        this.columnNames = columnNames;
        this.setColumnMappings(connection.getSql2o().getDefaultColumnMappings());
        this.caseSensitive = connection.getSql2o().isDefaultCaseSensitive();
        this.parsedQuery = queryText;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Query setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public boolean isAutoDeriveColumnNames() {
        return this.autoDeriveColumnNames;
    }

    public Query setAutoDeriveColumnNames(boolean autoDeriveColumnNames) {
        this.autoDeriveColumnNames = autoDeriveColumnNames;
        return this;
    }

    public Query throwOnMappingFailure(boolean throwOnMappingFailure) {
        this.throwOnMappingFailure = throwOnMappingFailure;
        return this;
    }

    public boolean isThrowOnMappingFailure() {
        return this.throwOnMappingFailure;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.name;
    }

    public Query setName(String name) {
        this.name = name;
        return this;
    }

    public ResultSetHandlerFactoryBuilder getResultSetHandlerFactoryBuilder() {
        if (this.resultSetHandlerFactoryBuilder == null) {
            this.resultSetHandlerFactoryBuilder = new DefaultResultSetHandlerFactoryBuilder();
        }
        return this.resultSetHandlerFactoryBuilder;
    }

    public void setResultSetHandlerFactoryBuilder(ResultSetHandlerFactoryBuilder resultSetHandlerFactoryBuilder) {
        this.resultSetHandlerFactoryBuilder = resultSetHandlerFactoryBuilder;
    }

    public Query withParams(Collection<Object> paramValues) {
        if (null == paramValues) {
            return this;
        }
        int i = 0;
        for (Object paramValue : paramValues) {
            this.paramIndexValues.put(++i, this.converterValue(paramValue));
        }
        return this;
    }

    public Query withParams(Object ... paramValues) {
        if (null == paramValues) {
            return this;
        }
        int i = 0;
        for (Object paramValue : paramValues) {
            this.paramIndexValues.put(++i, this.converterValue(paramValue));
        }
        return this;
    }

    private <T> Object converterValue(Object value) {
        Converter<?> converter;
        if (value instanceof Enum && null != (converter = this.getQuirks().converterOf(value.getClass()))) {
            try {
                return converter.toDatabaseParam(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    @Override
    public void close() {
        if (this.preparedStatement != null) {
            this.connection.removeStatement(this.preparedStatement);
            try {
                this.getQuirks().closeStatement(this.preparedStatement);
            }
            catch (Throwable ex) {
                log.warn("Could not close statement.", ex);
            }
        }
    }

    PreparedStatement buildPreparedStatement() {
        return this.buildPreparedStatement(true);
    }

    private PreparedStatement buildPreparedStatement(boolean allowArrayParameters) {
        log.debug("Parameters  => {}", this.paramIndexValues.values());
        if (this.preparedStatement == null) {
            try {
                this.preparedStatement = this.columnNames != null && this.columnNames.length > 0 ? this.connection.getJdbcConnection().prepareStatement(this.parsedQuery, this.columnNames) : (this.returnGeneratedKeys ? this.connection.getJdbcConnection().prepareStatement(this.parsedQuery, 1) : this.connection.getJdbcConnection().prepareStatement(this.parsedQuery));
            }
            catch (SQLException ex) {
                throw new Sql2oException(String.format("Error preparing statement - %s", ex.getMessage()), ex);
            }
            this.connection.registerStatement(this.preparedStatement);
        }
        for (Map.Entry<Integer, Object> entry : this.paramIndexValues.entrySet()) {
            try {
                this.getQuirks().setParameter(this.preparedStatement, (int)entry.getKey(), entry.getValue());
            }
            catch (SQLException e) {
                throw new RuntimeException(String.format("Error adding parameter '%s' - %s", entry.getKey(), e.getMessage()), e);
            }
        }
        this.paramIndexValues.clear();
        return this.preparedStatement;
    }

    public <T> ResultSetIterable<T> executeAndFetchLazy(Class<T> returnType) {
        ResultSetHandlerFactory<T> resultSetHandlerFactory = this.newResultSetHandlerFactory(returnType);
        return this.executeAndFetchLazy(resultSetHandlerFactory);
    }

    private <T> ResultSetHandlerFactory<T> newResultSetHandlerFactory(Class<T> returnType) {
        Quirks quirks = this.getConnection().getSql2o().getQuirks();
        ResultSetHandlerFactoryBuilder builder = this.getResultSetHandlerFactoryBuilder();
        if (builder == null) {
            builder = new DefaultResultSetHandlerFactoryBuilder();
        }
        builder.setAutoDeriveColumnNames(this.autoDeriveColumnNames);
        builder.setCaseSensitive(this.caseSensitive);
        builder.setColumnMappings(this.getColumnMappings());
        builder.setQuirks(quirks);
        builder.throwOnMappingError(this.throwOnMappingFailure);
        return builder.newFactory(returnType);
    }

    public <T> ResultSetIterable<T> executeAndFetchLazy(final ResultSetHandlerFactory<T> resultSetHandlerFactory) {
        final Quirks quirks = this.getConnection().getSql2o().getQuirks();
        return new ResultSetIterableBase<T>(){

            @Override
            public Iterator<T> iterator() {
                return new PojoResultSetIterator(this.rs, Query.this.isCaseSensitive(), quirks, resultSetHandlerFactory);
            }
        };
    }

    public <T> ResultSetIterable<T> executeAndFetchLazy(ResultSetHandler<T> resultSetHandler) {
        ResultSetHandlerFactory<T> factory = Query.newResultSetHandlerFactory(resultSetHandler);
        return this.executeAndFetchLazy(factory);
    }

    private static <T> ResultSetHandlerFactory<T> newResultSetHandlerFactory(ResultSetHandler<T> resultSetHandler) {
        return resultSetMetaData -> resultSetHandler;
    }

    public <T> List<T> executeAndFetch(Class<T> returnType) {
        return this.executeAndFetch(this.newResultSetHandlerFactory(returnType));
    }

    public <T> List<T> executeAndFetch(ResultSetHandler<T> resultSetHandler) {
        return this.executeAndFetch(Query.newResultSetHandlerFactory(resultSetHandler));
    }

    public <T> List<T> executeAndFetch(ResultSetHandlerFactory<T> factory) {
        ArrayList list = new ArrayList();
        try (ResultSetIterable<T> iterable = this.executeAndFetchLazy(factory);){
            for (Object item : iterable) {
                list.add(item);
            }
        }
        return list;
    }

    public <T> T executeAndFetchFirst(Class<T> returnType) {
        return this.executeAndFetchFirst(this.newResultSetHandlerFactory(returnType));
    }

    public <T> T executeAndFetchFirst(ResultSetHandler<T> resultSetHandler) {
        return this.executeAndFetchFirst(Query.newResultSetHandlerFactory(resultSetHandler));
    }

    public <T> T executeAndFetchFirst(ResultSetHandlerFactory<T> resultSetHandlerFactory) {
        try (ResultSetIterable<T> iterable = this.executeAndFetchLazy(resultSetHandlerFactory);){
            Iterator iterator = iterable.iterator();
            T t = iterator.hasNext() ? (T)iterator.next() : null;
            return t;
        }
    }

    public LazyTable executeAndFetchTableLazy() {
        final LazyTable lt = new LazyTable();
        lt.setRows((ResultSetIterable<Row>)new ResultSetIterableBase<Row>(){

            @Override
            public Iterator<Row> iterator() {
                return new TableResultSetIterator(this.rs, Query.this.isCaseSensitive(), Query.this.getConnection().getSql2o().getQuirks(), lt);
            }
        });
        return lt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table executeAndFetchTable() {
        ArrayList<Row> rows = new ArrayList<Row>();
        try (LazyTable lt = this.executeAndFetchTableLazy();){
            for (Row item : lt.rows()) {
                rows.add(item);
            }
        }
        return new Table(lt.getName(), rows, lt.columns());
    }

    public Connection executeUpdate() {
        long start = System.currentTimeMillis();
        try {
            this.logExecution();
            PreparedStatement statement = this.buildPreparedStatement();
            this.connection.setResult(statement.executeUpdate());
            this.connection.setKeys(this.returnGeneratedKeys ? statement.getGeneratedKeys() : null);
            this.connection.setCanGetKeys(this.returnGeneratedKeys);
        }
        catch (SQLException ex) {
            this.connection.onException();
            throw new Sql2oException("Error in executeUpdate, " + ex.getMessage(), ex);
        }
        finally {
            this.closeConnectionIfNecessary();
        }
        if (Anima.of().isEnableSQLStatistic() && log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug("total: {} ms; executed update [{}]", (Object)(end - start), (Object)(this.getName() == null ? "No name" : this.getName()));
        }
        return this.connection;
    }

    public Object executeScalar() {
        long start = System.currentTimeMillis();
        try {
            this.logExecution();
            ResultSet rs = this.buildPreparedStatement().executeQuery();
            if (rs.next()) {
                Object o = this.getQuirks().getRSVal(rs, 1);
                if (Anima.me().isEnableSQLStatistic() && log.isDebugEnabled()) {
                    long end = System.currentTimeMillis();
                    log.debug("total: {} ms; executed scalar [{}]", (Object)(end - start), (Object)(this.getName() == null ? "No name" : this.getName()));
                }
                Object object = o;
                return object;
            }
            Object var4_5 = null;
            return var4_5;
        }
        catch (SQLException e) {
            this.connection.onException();
            throw new Sql2oException("Database error occurred while running executeScalar: " + e.getMessage(), e);
        }
        finally {
            this.closeConnectionIfNecessary();
        }
    }

    private Quirks getQuirks() {
        return this.connection.getSql2o().getQuirks();
    }

    public <V> V executeScalar(Class<V> returnType) {
        try {
            Converter<V> converter = Convert.throwIfNull(returnType, this.getQuirks().converterOf(returnType));
            this.logExecution();
            return this.executeScalar(converter);
        }
        catch (ConverterException e) {
            throw new Sql2oException("Error occured while converting value from database to type " + returnType, e);
        }
    }

    public <V> V executeScalar(Converter<V> converter) {
        try {
            return converter.convert(this.executeScalar());
        }
        catch (ConverterException e) {
            throw new Sql2oException("Error occured while converting value from database", e);
        }
    }

    public <T> List<T> executeScalarList(Class<T> returnType) {
        return this.executeAndFetch(this.newScalarResultSetHandler(returnType));
    }

    private <T> ResultSetHandler<T> newScalarResultSetHandler(Class<T> returnType) {
        Quirks quirks = this.getQuirks();
        try {
            Converter converter = Convert.throwIfNull(returnType, quirks.converterOf(returnType));
            return resultSet -> {
                Object value = quirks.getRSVal(resultSet, 1);
                try {
                    return converter.convert(value);
                }
                catch (ConverterException e) {
                    throw new Sql2oException("Error occurred while converting value from database to type " + returnType, e);
                }
            };
        }
        catch (ConverterException e) {
            throw new Sql2oException("Can't get converter for type " + returnType, e);
        }
    }

    public Query setMaxBatchRecords(int maxBatchRecords) {
        if (maxBatchRecords < 0) {
            throw new IllegalArgumentException("maxBatchRecords should be a nonnegative value");
        }
        this.maxBatchRecords = maxBatchRecords;
        return this;
    }

    public int getMaxBatchRecords() {
        return this.maxBatchRecords;
    }

    public int getCurrentBatchRecords() {
        return this.currentBatchRecords;
    }

    public boolean isExplicitExecuteBatchRequired() {
        return this.maxBatchRecords > 0 && this.currentBatchRecords > 0 || this.maxBatchRecords == 0;
    }

    public Query addToBatch() {
        try {
            this.buildPreparedStatement(false).addBatch();
            if (this.maxBatchRecords > 0 && ++this.currentBatchRecords % this.maxBatchRecords == 0) {
                this.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new Sql2oException("Error while adding statement to batch", e);
        }
        return this;
    }

    public <A> List<A> addToBatchGetKeys(Class<A> klass) {
        this.addToBatch();
        if (this.currentBatchRecords == 0) {
            return this.connection.getKeys(klass);
        }
        return Collections.emptyList();
    }

    public Connection executeBatch() throws Sql2oException {
        long start = System.currentTimeMillis();
        try {
            this.logExecution();
            PreparedStatement statement = this.buildPreparedStatement();
            this.connection.setBatchResult(statement.executeBatch());
            this.currentBatchRecords = 0;
            try {
                this.connection.setKeys(this.returnGeneratedKeys ? statement.getGeneratedKeys() : null);
                this.connection.setCanGetKeys(this.returnGeneratedKeys);
            }
            catch (SQLException sqlex) {
                throw new Sql2oException("Error while trying to fetch generated keys from database. If you are not expecting any generated keys, fix this error by setting the fetchGeneratedKeys parameter in the createQuery() method to 'false'", sqlex);
            }
        }
        catch (Throwable e) {
            this.connection.onException();
            throw new Sql2oException("Error while executing batch operation: " + e.getMessage(), e);
        }
        finally {
            this.closeConnectionIfNecessary();
        }
        if (Anima.me().isEnableSQLStatistic() && log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug("total: {} ms; executed batch [{}]", (Object)(end - start), (Object)(this.getName() == null ? "No name" : this.getName()));
        }
        return this.connection;
    }

    public Map<String, String> getColumnMappings() {
        if (this.isCaseSensitive()) {
            return this.caseSensitiveColumnMappings;
        }
        return this.columnMappings;
    }

    public Query setColumnMappings(Map<String, String> mappings) {
        this.caseSensitiveColumnMappings = new HashMap<String, String>();
        this.columnMappings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            this.caseSensitiveColumnMappings.put(entry.getKey(), entry.getValue());
            this.columnMappings.put(entry.getKey().toLowerCase(), entry.getValue().toLowerCase());
        }
        return this;
    }

    public Query addColumnMapping(String columnName, String propertyName) {
        this.caseSensitiveColumnMappings.put(columnName, propertyName);
        this.columnMappings.put(columnName.toLowerCase(), propertyName.toLowerCase());
        return this;
    }

    private void closeConnectionIfNecessary() {
        try {
            if (this.connection.autoClose) {
                this.connection.close();
            }
        }
        catch (Exception ex) {
            throw new Sql2oException("Error while attempting to close connection", ex);
        }
    }

    private void logExecution() {
        log.debug("Execute SQL => {}", (Object)this.parsedQuery);
    }

    private abstract class ResultSetIterableBase<T>
    implements ResultSetIterable<T> {
        private long start;
        private long afterExecQuery;
        protected ResultSet rs;
        boolean autoCloseConnection = false;

        public ResultSetIterableBase() {
            try {
                this.start = System.currentTimeMillis();
                Query.this.logExecution();
                this.rs = Query.this.buildPreparedStatement().executeQuery();
                this.afterExecQuery = System.currentTimeMillis();
            }
            catch (SQLException ex) {
                throw new Sql2oException("Database error: " + ex.getMessage(), ex);
            }
        }

        @Override
        public void close() {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    if (Anima.me().isEnableSQLStatistic() && log.isDebugEnabled()) {
                        long afterClose = System.currentTimeMillis();
                        log.debug("Total       => {} ms, execution: {} ms, reading and parsing: {} ms; executed [{}]", new Object[]{afterClose - this.start, this.afterExecQuery - this.start, afterClose - this.afterExecQuery, Query.this.name});
                    }
                    this.rs = null;
                }
            }
            catch (SQLException ex) {
                throw new Sql2oException("Error closing ResultSet.", ex);
            }
            finally {
                if (this.isAutoCloseConnection()) {
                    Query.this.connection.close();
                } else {
                    Query.this.closeConnectionIfNecessary();
                }
            }
        }

        @Override
        public boolean isAutoCloseConnection() {
            return this.autoCloseConnection;
        }

        @Override
        public void setAutoCloseConnection(boolean autoCloseConnection) {
            this.autoCloseConnection = autoCloseConnection;
        }
    }
}

