/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import oracle.sql.TIMESTAMP;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.converters.ConvertersProvider;
import org.sql2o.converters.DateConverter;

public class OracleDateConverter
extends DateConverter
implements ConvertersProvider {
    @Override
    public Date convert(Object val) throws ConverterException {
        if (val instanceof TIMESTAMP) {
            try {
                return ((TIMESTAMP)val).timestampValue();
            }
            catch (SQLException e) {
                throw new ConverterException("Error trying to convert oracle.sql.TIMESTAMP to DateTime", e);
            }
        }
        return super.convert(val);
    }

    @Override
    public void fill(Map<Class<?>, Converter<?>> mapToFill) {
        mapToFill.put(Date.class, new OracleDateConverter());
    }
}

