/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.pulsar.producer;

import io.github.majusko.pulsar.annotation.PulsarProducer;
import io.github.majusko.pulsar.collector.ProducerHolder;
import io.github.majusko.pulsar.constant.Serialization;
import io.github.majusko.pulsar.error.exception.ProducerInitException;
import io.github.majusko.pulsar.producer.PulsarProducerFactory;
import io.github.majusko.pulsar.utils.SchemaUtils;
import io.github.majusko.pulsar.utils.TopicUrlService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class ProducerCollector
implements BeanPostProcessor {
    private final PulsarClient pulsarClient;
    private final TopicUrlService topicUrlService;
    private final Map<String, Producer> producers = new ConcurrentHashMap<String, Producer>();

    public ProducerCollector(PulsarClient pulsarClient, TopicUrlService topicUrlService) {
        this.pulsarClient = pulsarClient;
        this.topicUrlService = topicUrlService;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Class<?> beanClass = bean.getClass();
        if (beanClass.isAnnotationPresent(PulsarProducer.class) && bean instanceof PulsarProducerFactory) {
            this.producers.putAll(((PulsarProducerFactory)bean).getTopics().entrySet().stream().map($ -> new ProducerHolder((String)$.getKey(), (Class)((ImmutablePair)$.getValue()).left, (Serialization)((Object)((Object)((ImmutablePair)$.getValue()).right)))).collect(Collectors.toMap(ProducerHolder::getTopic, this::buildProducer)));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    private Producer<?> buildProducer(ProducerHolder holder) {
        try {
            return this.pulsarClient.newProducer(this.getSchema(holder)).topic(this.topicUrlService.buildTopicUrl(holder.getTopic())).create();
        }
        catch (PulsarClientException e) {
            throw new ProducerInitException("Failed to init producer.", e);
        }
    }

    private <T> Schema<?> getSchema(ProducerHolder holder) throws RuntimeException {
        return SchemaUtils.getSchema(holder.getSerialization(), holder.getClazz());
    }

    Map<String, Producer> getProducers() {
        return this.producers;
    }
}

