/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.pulsar.utils;

import com.google.protobuf.GeneratedMessageV3;
import io.github.majusko.pulsar.constant.Serialization;
import io.github.majusko.pulsar.error.exception.ProducerInitException;
import java.lang.reflect.Method;
import org.apache.pulsar.client.api.Schema;

public class SchemaUtils {
    private SchemaUtils() {
    }

    private static <T> Schema<?> getGenericSchema(Serialization serialization, Class<T> clazz) throws RuntimeException {
        switch (serialization) {
            case JSON: {
                return Schema.JSON(clazz);
            }
            case AVRO: {
                return Schema.AVRO(clazz);
            }
            case STRING: {
                return Schema.STRING;
            }
        }
        throw new ProducerInitException("Unknown producer schema.");
    }

    private static <T extends GeneratedMessageV3> Schema<?> getProtoSchema(Serialization serialization, Class<T> clazz) throws RuntimeException {
        if (serialization == Serialization.PROTOBUF) {
            return Schema.PROTOBUF(clazz);
        }
        throw new ProducerInitException("Unknown producer schema.");
    }

    public static Schema<?> getSchema(Serialization serialisation, Class<?> clazz) {
        if (clazz == byte[].class) {
            return Schema.BYTES;
        }
        if (SchemaUtils.isProto(serialisation)) {
            return SchemaUtils.getProtoSchema(serialisation, clazz);
        }
        return SchemaUtils.getGenericSchema(serialisation, clazz);
    }

    public static boolean isProto(Serialization serialization) {
        return serialization == Serialization.PROTOBUF;
    }

    public static Class<?> getParameterType(Method method) {
        return method.getParameterTypes()[0];
    }
}

