/*
 * Decompiled with CFR 0.152.
 */
package io.jmnarloch.spring.request.correlation.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.jmnarloch.spring.request.correlation.support.RequestCorrelationProperties;
import io.jmnarloch.spring.request.correlation.support.RequestCorrelationUtils;
import org.springframework.util.Assert;

public class FeignCorrelationInterceptor
implements RequestInterceptor {
    private final RequestCorrelationProperties properties;

    public FeignCorrelationInterceptor(RequestCorrelationProperties properties) {
        Assert.notNull((Object)properties, (String)"Parameter 'properties' can not be null");
        this.properties = properties;
    }

    public void apply(RequestTemplate template) {
        String correlationId = RequestCorrelationUtils.getCurrentCorrelationId();
        if (correlationId != null) {
            template.header("X-Request-Id", new String[]{correlationId});
        }
    }
}

