/*
 * Decompiled with CFR 0.152.
 */
package io.jmnarloch.spring.request.correlation.filter;

import io.jmnarloch.spring.request.correlation.api.CorrelationIdGenerator;
import io.jmnarloch.spring.request.correlation.api.RequestCorrelation;
import io.jmnarloch.spring.request.correlation.api.RequestCorrelationInterceptor;
import io.jmnarloch.spring.request.correlation.filter.DefaultRequestCorrelation;
import io.jmnarloch.spring.request.correlation.support.RequestCorrelationProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RequestCorrelationFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(RequestCorrelationFilter.class);
    private final CorrelationIdGenerator correlationIdGenerator;
    private final List<RequestCorrelationInterceptor> interceptors;
    private final RequestCorrelationProperties properties;

    public RequestCorrelationFilter(CorrelationIdGenerator correlationIdGenerator, List<RequestCorrelationInterceptor> interceptors, RequestCorrelationProperties properties) {
        Assert.notNull((Object)correlationIdGenerator, (String)"Parameter 'correlationIdGenerator' can not be null.");
        Assert.notNull(interceptors, (String)"Parameter 'interceptors' can not be null.");
        Assert.notNull((Object)properties, (String)"Parameter 'properties' can not be null.");
        this.correlationIdGenerator = correlationIdGenerator;
        this.interceptors = interceptors;
        this.properties = properties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doHttpFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHttpFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String correlationId = this.getCorrelationId(request);
        if (StringUtils.isBlank((CharSequence)correlationId)) {
            correlationId = this.generateCorrelationId();
            this.logger.debug("Request correlation id was not present, generating new one: {}", (Object)correlationId);
        }
        this.triggerInterceptors(correlationId);
        DefaultRequestCorrelation requestCorrelation = new DefaultRequestCorrelation(correlationId);
        ServletRequest req = this.enrichRequest(request, requestCorrelation);
        try {
            chain.doFilter(req, (ServletResponse)response);
        }
        finally {
            this.triggerInterceptorsCleanup(correlationId);
        }
    }

    private String getCorrelationId(HttpServletRequest request) {
        return request.getHeader(this.properties.getHeaderName());
    }

    private String generateCorrelationId() {
        return this.correlationIdGenerator.generate();
    }

    private void triggerInterceptors(String correlationId) {
        for (RequestCorrelationInterceptor interceptor : this.interceptors) {
            interceptor.afterCorrelationIdSet(correlationId);
        }
    }

    private void triggerInterceptorsCleanup(String correlationId) {
        for (RequestCorrelationInterceptor interceptor : this.interceptors) {
            interceptor.cleanUp(correlationId);
        }
    }

    private ServletRequest enrichRequest(HttpServletRequest request, RequestCorrelation correlationId) {
        CorrelatedServletRequest req = new CorrelatedServletRequest(request);
        req.setAttribute("io.jmnarloch.spring.request.correlation.api.RequestCorrelation.ATTRIBUTE", correlationId);
        req.setHeader(this.properties.getHeaderName(), correlationId.getRequestId());
        return req;
    }

    private static class CorrelatedServletRequest
    extends HttpServletRequestWrapper {
        private final Map<String, String> additionalHeaders = new ConcurrentHashMap<String, String>();

        public CorrelatedServletRequest(HttpServletRequest request) {
            super(request);
        }

        public void setHeader(String key, String value) {
            this.additionalHeaders.put(key, value);
        }

        public String getHeader(String name) {
            if (this.additionalHeaders.containsKey(name)) {
                return this.additionalHeaders.get(name);
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            ArrayList<String> values = new ArrayList<String>();
            if (this.additionalHeaders.containsKey(name)) {
                values.add(this.additionalHeaders.get(name));
            } else {
                values.addAll(Collections.list(super.getHeaders(name)));
            }
            return Collections.enumeration(values);
        }

        public Enumeration<String> getHeaderNames() {
            HashSet<String> names = new HashSet<String>();
            names.addAll(this.additionalHeaders.keySet());
            names.addAll(Collections.list(super.getHeaderNames()));
            return Collections.enumeration(names);
        }
    }
}

