/*
 * Decompiled with CFR 0.152.
 */
package io.jmnarloch.spring.request.correlation.http;

import io.jmnarloch.spring.request.correlation.support.RequestCorrelationProperties;
import io.jmnarloch.spring.request.correlation.support.RequestCorrelationUtils;
import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class ClientHttpRequestCorrelationInterceptor
implements ClientHttpRequestInterceptor {
    private final RequestCorrelationProperties properties;

    public ClientHttpRequestCorrelationInterceptor(RequestCorrelationProperties properties) {
        Assert.notNull((Object)properties, (String)"Parameter 'properties' can not be null");
        this.properties = properties;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String correlationId = RequestCorrelationUtils.getCurrentCorrelationId();
        if (correlationId != null) {
            request.getHeaders().add("X-Request-Id", correlationId);
        }
        return execution.execute(request, body);
    }
}

