/*
 * Decompiled with CFR 0.152.
 */
package io.jmnarloch.spring.request.correlation.support;

import io.jmnarloch.spring.request.correlation.api.CorrelationIdGenerator;
import io.jmnarloch.spring.request.correlation.api.RequestCorrelationInterceptor;
import io.jmnarloch.spring.request.correlation.filter.RequestCorrelationFilter;
import io.jmnarloch.spring.request.correlation.generator.UuidGenerator;
import io.jmnarloch.spring.request.correlation.support.RequestCorrelationProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
public class RequestCorrelationConfiguration {
    @Autowired(required=false)
    private List<RequestCorrelationInterceptor> interceptors = new ArrayList<RequestCorrelationInterceptor>();

    @Bean
    public RequestCorrelationProperties requestCorrelationProperties() {
        return new RequestCorrelationProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={CorrelationIdGenerator.class})
    public CorrelationIdGenerator requestIdGenerator() {
        return new UuidGenerator();
    }

    @Bean
    public RequestCorrelationFilter requestCorrelationFilter(CorrelationIdGenerator generator, RequestCorrelationProperties properties) {
        return new RequestCorrelationFilter(generator, this.interceptors, properties);
    }

    @Bean
    public FilterRegistrationBean requestCorrelationFilterBean(RequestCorrelationFilter correlationFilter) {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)correlationFilter);
        filterRegistration.setMatchAfter(false);
        filterRegistration.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        filterRegistration.setAsyncSupported(true);
        filterRegistration.setOrder(Integer.MIN_VALUE);
        return filterRegistration;
    }
}

