/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CSIDriverSpec is the specification of a CSIDriver.")
public class V1CSIDriverSpec {
    public static final String SERIALIZED_NAME_ATTACH_REQUIRED = "attachRequired";
    @SerializedName(value="attachRequired")
    private Boolean attachRequired;
    public static final String SERIALIZED_NAME_FS_GROUP_POLICY = "fsGroupPolicy";
    @SerializedName(value="fsGroupPolicy")
    private String fsGroupPolicy;
    public static final String SERIALIZED_NAME_POD_INFO_ON_MOUNT = "podInfoOnMount";
    @SerializedName(value="podInfoOnMount")
    private Boolean podInfoOnMount;
    public static final String SERIALIZED_NAME_STORAGE_CAPACITY = "storageCapacity";
    @SerializedName(value="storageCapacity")
    private Boolean storageCapacity;
    public static final String SERIALIZED_NAME_VOLUME_LIFECYCLE_MODES = "volumeLifecycleModes";
    @SerializedName(value="volumeLifecycleModes")
    private List<String> volumeLifecycleModes = null;

    public V1CSIDriverSpec attachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="attachRequired indicates this CSI volume driver requires an attach operation (because it implements the CSI ControllerPublishVolume() method), and that the Kubernetes attach detach controller should call the attach volume interface which checks the volumeattachment status and waits until the volume is attached before proceeding to mounting. The CSI external-attacher coordinates with CSI volume driver and updates the volumeattachment status when the attach operation is complete. If the CSIDriverRegistry feature gate is enabled and the value is specified to false, the attach operation will be skipped. Otherwise the attach operation will be called.")
    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    public void setAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
    }

    public V1CSIDriverSpec fsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy = fsGroupPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines if the underlying volume supports changing ownership and permission of the volume before being mounted. Refer to the specific FSGroupPolicy values for additional details. This field is alpha-level, and is only honored by servers that enable the CSIVolumeFSGroupPolicy feature gate.")
    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    public void setFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy = fsGroupPolicy;
    }

    public V1CSIDriverSpec podInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true, podInfoOnMount indicates this CSI volume driver requires additional pod information (like podName, podUID, etc.) during mount operations. If set to false, pod information will not be passed on mount. Default is false. The CSI driver specifies podInfoOnMount as part of driver deployment. If true, Kubelet will pass pod information as VolumeContext in the CSI NodePublishVolume() calls. The CSI driver is responsible for parsing and validating the information passed in as VolumeContext. The following VolumeConext will be passed if podInfoOnMount is set to true. This list might grow, but the prefix will be used. \"csi.storage.k8s.io/pod.name\": pod.Name \"csi.storage.k8s.io/pod.namespace\": pod.Namespace \"csi.storage.k8s.io/pod.uid\": string(pod.UID) \"csi.storage.k8s.io/ephemeral\": \"true\" iff the volume is an ephemeral inline volume                                 defined by a CSIVolumeSource, otherwise \"false\"  \"csi.storage.k8s.io/ephemeral\" is a new feature in Kubernetes 1.16. It is only required for drivers which support both the \"Persistent\" and \"Ephemeral\" VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore this field. As Kubernetes 1.15 doesn't support this field, drivers can only support one mode when deployed on such a cluster and the deployment determines which mode that is, for example via a command line parameter of the driver.")
    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public void setPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
    }

    public V1CSIDriverSpec storageCapacity(Boolean storageCapacity) {
        this.storageCapacity = storageCapacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to true, storageCapacity indicates that the CSI volume driver wants pod scheduling to consider the storage capacity that the driver deployment will report by creating CSIStorageCapacity objects with capacity information.  The check can be enabled immediately when deploying a driver. In that case, provisioning new volumes with late binding will pause until the driver deployment has published some suitable CSIStorageCapacity object.  Alternatively, the driver can be deployed with the field unset or false and it can be flipped later when storage capacity information has been published.  This is an alpha field and only available when the CSIStorageCapacity feature is enabled. The default is false.")
    public Boolean getStorageCapacity() {
        return this.storageCapacity;
    }

    public void setStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity = storageCapacity;
    }

    public V1CSIDriverSpec volumeLifecycleModes(List<String> volumeLifecycleModes) {
        this.volumeLifecycleModes = volumeLifecycleModes;
        return this;
    }

    public V1CSIDriverSpec addVolumeLifecycleModesItem(String volumeLifecycleModesItem) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.add(volumeLifecycleModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeLifecycleModes defines what kind of volumes this CSI volume driver supports. The default if the list is empty is \"Persistent\", which is the usage defined by the CSI specification and implemented in Kubernetes via the usual PV/PVC mechanism. The other mode is \"Ephemeral\". In this mode, volumes are defined inline inside the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle of that pod. A driver has to be aware of this because it is only going to get a NodePublishVolume call for such a volume. For more information about implementing this mode, see https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver can support one or more of these modes and more modes may be added in the future. This field is beta.")
    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    public void setVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        this.volumeLifecycleModes = volumeLifecycleModes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIDriverSpec v1CSIDriverSpec = (V1CSIDriverSpec)o;
        return Objects.equals(this.attachRequired, v1CSIDriverSpec.attachRequired) && Objects.equals(this.fsGroupPolicy, v1CSIDriverSpec.fsGroupPolicy) && Objects.equals(this.podInfoOnMount, v1CSIDriverSpec.podInfoOnMount) && Objects.equals(this.storageCapacity, v1CSIDriverSpec.storageCapacity) && Objects.equals(this.volumeLifecycleModes, v1CSIDriverSpec.volumeLifecycleModes);
    }

    public int hashCode() {
        return Objects.hash(this.attachRequired, this.fsGroupPolicy, this.podInfoOnMount, this.storageCapacity, this.volumeLifecycleModes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CSIDriverSpec {\n");
        sb.append("    attachRequired: ").append(this.toIndentedString(this.attachRequired)).append("\n");
        sb.append("    fsGroupPolicy: ").append(this.toIndentedString(this.fsGroupPolicy)).append("\n");
        sb.append("    podInfoOnMount: ").append(this.toIndentedString(this.podInfoOnMount)).append("\n");
        sb.append("    storageCapacity: ").append(this.toIndentedString(this.storageCapacity)).append("\n");
        sb.append("    volumeLifecycleModes: ").append(this.toIndentedString(this.volumeLifecycleModes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

