/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.")
public class V1beta1CertificateSigningRequestSpec {
    public static final String SERIALIZED_NAME_EXTRA = "extra";
    @SerializedName(value="extra")
    private Map<String, List<String>> extra = null;
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private List<String> groups = null;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private byte[] request;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private String uid;
    public static final String SERIALIZED_NAME_USAGES = "usages";
    @SerializedName(value="usages")
    private List<String> usages = null;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;

    public V1beta1CertificateSigningRequestSpec extra(Map<String, List<String>> extra) {
        this.extra = extra;
        return this;
    }

    public V1beta1CertificateSigningRequestSpec putExtraItem(String key, List<String> extraItem) {
        if (this.extra == null) {
            this.extra = new HashMap<String, List<String>>();
        }
        this.extra.put(key, extraItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Extra information about the requesting user. See user.Info interface for details.")
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, List<String>> extra) {
        this.extra = extra;
    }

    public V1beta1CertificateSigningRequestSpec groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public V1beta1CertificateSigningRequestSpec addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group information about the requesting user. See user.Info interface for details.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public V1beta1CertificateSigningRequestSpec request(byte[] request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(required=true, value="Base64-encoded PKCS#10 CSR data")
    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public V1beta1CertificateSigningRequestSpec uid(String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID information about the requesting user. See user.Info interface for details.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public V1beta1CertificateSigningRequestSpec usages(List<String> usages) {
        this.usages = usages;
        return this;
    }

    public V1beta1CertificateSigningRequestSpec addUsagesItem(String usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allowedUsages specifies a set of usage contexts the key will be valid for. See: https://tools.ietf.org/html/rfc5280#section-4.2.1.3      https://tools.ietf.org/html/rfc5280#section-4.2.1.12")
    public List<String> getUsages() {
        return this.usages;
    }

    public void setUsages(List<String> usages) {
        this.usages = usages;
    }

    public V1beta1CertificateSigningRequestSpec username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information about the requesting user. See user.Info interface for details.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateSigningRequestSpec v1beta1CertificateSigningRequestSpec = (V1beta1CertificateSigningRequestSpec)o;
        return Objects.equals(this.extra, v1beta1CertificateSigningRequestSpec.extra) && Objects.equals(this.groups, v1beta1CertificateSigningRequestSpec.groups) && Arrays.equals(this.request, v1beta1CertificateSigningRequestSpec.request) && Objects.equals(this.uid, v1beta1CertificateSigningRequestSpec.uid) && Objects.equals(this.usages, v1beta1CertificateSigningRequestSpec.usages) && Objects.equals(this.username, v1beta1CertificateSigningRequestSpec.username);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.groups, Arrays.hashCode(this.request), this.uid, this.usages, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateSigningRequestSpec {\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

