/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.internal.LettuceAssert;
import java.io.Serializable;

public class ClientOptions
implements Serializable {
    public static final boolean DEFAULT_PING_BEFORE_ACTIVATE_CONNECTION = false;
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final boolean DEFAULT_CANCEL_CMD_RECONNECT_FAIL = false;
    public static final boolean DEFAULT_SUSPEND_RECONNECT_PROTO_FAIL = false;
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = Integer.MAX_VALUE;
    public static final DisconnectedBehavior DEFAULT_DISCONNECTED_BEHAVIOR = DisconnectedBehavior.DEFAULT;
    public static final SocketOptions DEFAULT_SOCKET_OPTIONS = SocketOptions.create();
    public static final SslOptions DEFAULT_SSL_OPTIONS = SslOptions.create();
    public static final TimeoutOptions DEFAULT_TIMEOUT_OPTIONS = TimeoutOptions.create();
    private final boolean pingBeforeActivateConnection;
    private final boolean autoReconnect;
    private final boolean cancelCommandsOnReconnectFailure;
    private final boolean suspendReconnectOnProtocolFailure;
    private final int requestQueueSize;
    private final DisconnectedBehavior disconnectedBehavior;
    private final SocketOptions socketOptions;
    private final SslOptions sslOptions;
    private final TimeoutOptions timeoutOptions;

    protected ClientOptions(Builder builder) {
        this.pingBeforeActivateConnection = builder.pingBeforeActivateConnection;
        this.cancelCommandsOnReconnectFailure = builder.cancelCommandsOnReconnectFailure;
        this.autoReconnect = builder.autoReconnect;
        this.suspendReconnectOnProtocolFailure = builder.suspendReconnectOnProtocolFailure;
        this.requestQueueSize = builder.requestQueueSize;
        this.disconnectedBehavior = builder.disconnectedBehavior;
        this.socketOptions = builder.socketOptions;
        this.sslOptions = builder.sslOptions;
        this.timeoutOptions = builder.timeoutOptions;
    }

    protected ClientOptions(ClientOptions original) {
        this.pingBeforeActivateConnection = original.isPingBeforeActivateConnection();
        this.autoReconnect = original.isAutoReconnect();
        this.cancelCommandsOnReconnectFailure = original.isCancelCommandsOnReconnectFailure();
        this.suspendReconnectOnProtocolFailure = original.isSuspendReconnectOnProtocolFailure();
        this.requestQueueSize = original.getRequestQueueSize();
        this.disconnectedBehavior = original.getDisconnectedBehavior();
        this.socketOptions = original.getSocketOptions();
        this.sslOptions = original.getSslOptions();
        this.timeoutOptions = original.getTimeoutOptions();
    }

    public static ClientOptions copyOf(ClientOptions options) {
        return new ClientOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClientOptions create() {
        return ClientOptions.builder().build();
    }

    public boolean isPingBeforeActivateConnection() {
        return this.pingBeforeActivateConnection;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isCancelCommandsOnReconnectFailure() {
        return this.cancelCommandsOnReconnectFailure;
    }

    public boolean isSuspendReconnectOnProtocolFailure() {
        return this.suspendReconnectOnProtocolFailure;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public DisconnectedBehavior getDisconnectedBehavior() {
        return this.disconnectedBehavior;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    public TimeoutOptions getTimeoutOptions() {
        return this.timeoutOptions;
    }

    public static enum DisconnectedBehavior {
        DEFAULT,
        ACCEPT_COMMANDS,
        REJECT_COMMANDS;

    }

    public static class Builder {
        private boolean pingBeforeActivateConnection = false;
        private boolean autoReconnect = true;
        private boolean cancelCommandsOnReconnectFailure = false;
        private boolean suspendReconnectOnProtocolFailure = false;
        private int requestQueueSize = Integer.MAX_VALUE;
        private DisconnectedBehavior disconnectedBehavior = DEFAULT_DISCONNECTED_BEHAVIOR;
        private SocketOptions socketOptions = DEFAULT_SOCKET_OPTIONS;
        private SslOptions sslOptions = DEFAULT_SSL_OPTIONS;
        private TimeoutOptions timeoutOptions = DEFAULT_TIMEOUT_OPTIONS;

        protected Builder() {
        }

        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            this.pingBeforeActivateConnection = pingBeforeActivateConnection;
            return this;
        }

        public Builder autoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
            return this;
        }

        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            this.cancelCommandsOnReconnectFailure = cancelCommandsOnReconnectFailure;
            return this;
        }

        public Builder requestQueueSize(int requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        public Builder disconnectedBehavior(DisconnectedBehavior disconnectedBehavior) {
            LettuceAssert.notNull((Object)disconnectedBehavior, "DisconnectedBehavior must not be null");
            this.disconnectedBehavior = disconnectedBehavior;
            return this;
        }

        public Builder socketOptions(SocketOptions socketOptions) {
            LettuceAssert.notNull(socketOptions, "SocketOptions must not be null");
            this.socketOptions = socketOptions;
            return this;
        }

        public Builder sslOptions(SslOptions sslOptions) {
            LettuceAssert.notNull(sslOptions, "SslOptions must not be null");
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder timeoutOptions(TimeoutOptions timeoutOptions) {
            LettuceAssert.notNull(timeoutOptions, "TimeoutOptions must not be null");
            this.timeoutOptions = timeoutOptions;
            return this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

