/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.CloseEvents;
import io.lettuce.core.FutureSyncInvocationHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.internal.AsyncCloseable;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandExpiryWriter;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class RedisChannelHandler<K, V>
implements Closeable,
ConnectionFacade {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    private static final AtomicIntegerFieldUpdater<RedisChannelHandler> CLOSED = AtomicIntegerFieldUpdater.newUpdater(RedisChannelHandler.class, "closed");
    private static final int ST_OPEN = 0;
    private static final int ST_CLOSED = 1;
    private Duration timeout;
    private CloseEvents closeEvents = new CloseEvents();
    private final RedisChannelWriter channelWriter;
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile int closed = 0;
    private volatile boolean active = true;
    private volatile ClientOptions clientOptions;

    public RedisChannelHandler(RedisChannelWriter writer, Duration timeout) {
        this.channelWriter = writer;
        writer.setConnectionFacade(this);
        this.setTimeout(timeout);
    }

    public void setTimeout(Duration timeout) {
        LettuceAssert.notNull(timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.timeout = timeout;
        if (this.channelWriter instanceof CommandExpiryWriter) {
            ((CommandExpiryWriter)this.channelWriter).setTimeout(timeout);
        }
    }

    @Deprecated
    public void setTimeout(long timeout, TimeUnit unit) {
        this.setTimeout(Duration.ofNanos(unit.toNanos(timeout)));
    }

    @Override
    public void close() {
        if (this.debugEnabled) {
            logger.debug("close()");
        }
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.debugEnabled) {
            logger.debug("closeAsync()");
        }
        if (CLOSED.get(this) == 1) {
            logger.warn("Connection is already closed");
            return this.closeFuture;
        }
        if (CLOSED.compareAndSet(this, 0, 1)) {
            this.active = false;
            CompletableFuture<Void> future = this.channelWriter.closeAsync();
            future.whenComplete((v, t) -> {
                this.closeEvents.fireEventClosed(this);
                this.closeEvents = new CloseEvents();
                if (t != null) {
                    this.closeFuture.completeExceptionally((Throwable)t);
                } else {
                    this.closeFuture.complete((Void)v);
                }
            });
        } else {
            logger.warn("Connection is already closed (concurrently)");
        }
        return this.closeFuture;
    }

    protected <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        if (this.debugEnabled) {
            logger.debug("dispatching command {}", cmd);
        }
        return this.channelWriter.write(cmd);
    }

    protected Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        if (this.debugEnabled) {
            logger.debug("dispatching commands {}", commands);
        }
        return this.channelWriter.write(commands);
    }

    public void registerCloseables(Collection<Closeable> registry, Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener(resource -> {
            for (Closeable closeable : closeables) {
                if (closeable == this) continue;
                try {
                    if (closeable instanceof AsyncCloseable) {
                        ((AsyncCloseable)((Object)closeable)).closeAsync();
                        continue;
                    }
                    closeable.close();
                }
                catch (IOException e) {
                    if (!this.debugEnabled) continue;
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
            registry.removeAll(Arrays.asList(closeables));
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return CLOSED.get(this) == 1;
    }

    @Override
    public void activated() {
        this.active = true;
        CLOSED.set(this, 0);
    }

    @Override
    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    @Override
    public void reset() {
        this.channelWriter.reset();
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    protected <T> T syncHandler(Object asyncApi, Class<?> ... interfaces) {
        FutureSyncInvocationHandler h = new FutureSyncInvocationHandler((StatefulConnection)((Object)this), asyncApi, interfaces);
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, (InvocationHandler)h);
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.getChannelWriter().setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.getChannelWriter().flushCommands();
    }
}

