/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.segment;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.annotation.Command;
import io.lettuce.core.dynamic.annotation.CommandNaming;
import io.lettuce.core.dynamic.segment.CommandSegment;
import io.lettuce.core.dynamic.segment.CommandSegmentFactory;
import io.lettuce.core.dynamic.segment.CommandSegments;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class AnnotationCommandSegmentFactory
implements CommandSegmentFactory {
    private static final Pattern SPACE = Pattern.compile("\\s");
    private static final String INDEX_BASED_PARAM_START = "?";
    private static final String NAME_BASED_PARAM_START = ":";

    @Override
    public CommandSegments createCommandSegments(CommandMethod commandMethod) {
        if (CommandSegmentParser.INSTANCE.hasCommandString(commandMethod)) {
            return CommandSegmentParser.INSTANCE.createCommandSegments(commandMethod);
        }
        CommandNaming.LetterCase letterCase = this.getLetterCase(commandMethod);
        CommandNaming.Strategy strategy = this.getNamingStrategy(commandMethod);
        List<String> parts = this.parseMethodName(commandMethod.getName(), strategy);
        return this.createCommandSegments(parts, letterCase);
    }

    private CommandSegments createCommandSegments(List<String> parts, CommandNaming.LetterCase letterCase) {
        ArrayList<CommandSegment> segments = new ArrayList<CommandSegment>(parts.size());
        for (String part : parts) {
            if (letterCase == CommandNaming.LetterCase.AS_IS) {
                segments.add(CommandSegment.constant(part));
                continue;
            }
            segments.add(CommandSegment.constant(part.toUpperCase()));
        }
        return new CommandSegments(segments);
    }

    private List<String> parseMethodName(String name, CommandNaming.Strategy strategy) {
        if (strategy == CommandNaming.Strategy.METHOD_NAME) {
            return Collections.singletonList(name);
        }
        ArrayList<String> parts = new ArrayList<String>();
        char[] chars = name.toCharArray();
        boolean previousUpperCase = false;
        StringBuffer buffer = new StringBuffer(chars.length);
        for (char theChar : chars) {
            if (!Character.isUpperCase(theChar)) {
                buffer.append(theChar);
                previousUpperCase = false;
                continue;
            }
            if (!previousUpperCase && !LettuceStrings.isEmpty(buffer)) {
                if (strategy == CommandNaming.Strategy.DOT) {
                    buffer.append('.');
                }
                if (strategy == CommandNaming.Strategy.SPLIT) {
                    parts.add(buffer.toString());
                    buffer = new StringBuffer(chars.length);
                }
            }
            previousUpperCase = true;
            buffer.append(theChar);
        }
        if (LettuceStrings.isNotEmpty(buffer)) {
            parts.add(buffer.toString());
        }
        return parts;
    }

    private CommandNaming.LetterCase getLetterCase(CommandMethod commandMethod) {
        CommandNaming.LetterCase letterCase;
        if (commandMethod.hasAnnotation(CommandNaming.class) && (letterCase = commandMethod.getMethod().getAnnotation(CommandNaming.class).letterCase()) != CommandNaming.LetterCase.DEFAULT) {
            return letterCase;
        }
        Class<?> declaringClass = commandMethod.getMethod().getDeclaringClass();
        CommandNaming annotation = declaringClass.getAnnotation(CommandNaming.class);
        if (annotation != null && annotation.letterCase() != CommandNaming.LetterCase.DEFAULT) {
            return annotation.letterCase();
        }
        return CommandNaming.LetterCase.UPPERCASE;
    }

    private CommandNaming.Strategy getNamingStrategy(CommandMethod commandMethod) {
        CommandNaming.Strategy strategy;
        if (commandMethod.hasAnnotation(CommandNaming.class) && (strategy = commandMethod.getMethod().getAnnotation(CommandNaming.class).strategy()) != CommandNaming.Strategy.DEFAULT) {
            return strategy;
        }
        Class<?> declaringClass = commandMethod.getMethod().getDeclaringClass();
        CommandNaming annotation = declaringClass.getAnnotation(CommandNaming.class);
        if (annotation != null && annotation.strategy() != CommandNaming.Strategy.DEFAULT) {
            return annotation.strategy();
        }
        return CommandNaming.Strategy.SPLIT;
    }

    private static enum CommandSegmentParser implements CommandSegmentFactory
    {
        INSTANCE;


        @Override
        public CommandSegments createCommandSegments(CommandMethod commandMethod) {
            return this.parse(this.getCommandString(commandMethod));
        }

        private CommandSegments parse(String command) {
            Object[] split = SPACE.split(command);
            LettuceAssert.notEmpty(split, "Command must not be empty");
            return this.getCommandSegments((String[])split);
        }

        private CommandSegments getCommandSegments(String[] split) {
            ArrayList<CommandSegment> segments = new ArrayList<CommandSegment>();
            for (String segment : split) {
                if (segment.startsWith(AnnotationCommandSegmentFactory.INDEX_BASED_PARAM_START)) {
                    segments.add(this.parseIndexBasedArgument(segment));
                    continue;
                }
                if (segment.startsWith(AnnotationCommandSegmentFactory.NAME_BASED_PARAM_START)) {
                    segments.add(this.parseNameBasedArgument(segment));
                    continue;
                }
                segments.add(CommandSegment.constant(segment));
            }
            return new CommandSegments(segments);
        }

        private CommandSegment parseIndexBasedArgument(String segment) {
            String index = segment.substring(AnnotationCommandSegmentFactory.INDEX_BASED_PARAM_START.length());
            return this.getIndexBasedArgument(index);
        }

        private CommandSegment parseNameBasedArgument(String segment) {
            return CommandSegment.namedParameter(segment.substring(AnnotationCommandSegmentFactory.NAME_BASED_PARAM_START.length()));
        }

        private CommandSegment getIndexBasedArgument(String index) {
            return CommandSegment.indexedParameter(Integer.parseInt(index));
        }

        private String getCommandString(CommandMethod commandMethod) {
            Command annotation = commandMethod.getAnnotation(Command.class);
            return annotation.value();
        }

        private boolean hasCommandString(CommandMethod commandMethod) {
            if (commandMethod.hasAnnotation(Command.class)) {
                Command annotation = commandMethod.getAnnotation(Command.class);
                return LettuceStrings.isNotEmpty(annotation.value());
            }
            return false;
        }
    }
}

