/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.jdbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;

@NonNullApi
@NonNullFields
public class DataSourcePoolMetrics
implements MeterBinder {
    private final DataSource dataSource;
    private final String name;
    private final Iterable<Tag> tags;
    @Nullable
    private final DataSourcePoolMetadata poolMetadata;

    public DataSourcePoolMetrics(DataSource dataSource, @Nullable Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.dataSource = dataSource;
        DataSourcePoolMetadataProviders provider = new DataSourcePoolMetadataProviders(metadataProviders);
        this.poolMetadata = provider.getDataSourcePoolMetadata(dataSource);
    }

    public void bindTo(MeterRegistry registry) {
        if (this.poolMetadata != null) {
            registry.gauge(this.name + ".connections.active", this.tags, (Object)this.dataSource, dataSource -> this.poolMetadata.getActive() != null ? (double)this.poolMetadata.getActive().intValue() : 0.0);
            registry.gauge(this.name + ".connections.max", this.tags, (Object)this.dataSource, dataSource -> this.poolMetadata.getMax().intValue());
            registry.gauge(this.name + ".connections.min", this.tags, (Object)this.dataSource, dataSource -> this.poolMetadata.getMin().intValue());
        }
    }
}

