/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class GetReplicasParam {
    private final String databaseName;
    private final String collectionName;
    private boolean withShardNodes;

    private GetReplicasParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.withShardNodes = true;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isWithShardNodes() {
        return this.withShardNodes;
    }

    public String toString() {
        return "GetReplicasParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", withShardNodes=" + this.isWithShardNodes() + ")";
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public GetReplicasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetReplicasParam(this);
        }
    }
}

