/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildProvider;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.BuildStepBuilder;
import io.quarkus.builder.ChainBuildException;
import io.quarkus.builder.Constraint;
import io.quarkus.builder.Consume;
import io.quarkus.builder.ConsumeFlag;
import io.quarkus.builder.FinalStep;
import io.quarkus.builder.ItemId;
import io.quarkus.builder.Produce;
import io.quarkus.builder.ProduceFlag;
import io.quarkus.builder.StepInfo;
import io.quarkus.builder.item.BuildItem;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.common.Assert;

public final class BuildChainBuilder {
    private static final String GRAPH_OUTPUT = System.getProperty("jboss.builder.graph-output");
    private final BuildStepBuilder finalStep;
    private final List<BuildProvider> providers = new ArrayList<BuildProvider>();
    private final Map<BuildStepBuilder, StackTraceElement[]> steps = new HashMap<BuildStepBuilder, StackTraceElement[]>();
    private final Set<ItemId> initialIds = new HashSet<ItemId>();
    private final Set<ItemId> finalIds = new HashSet<ItemId>();
    private ClassLoader classLoader = BuildChainBuilder.class.getClassLoader();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("[\"]");

    BuildChainBuilder() {
        this.finalStep = this.addBuildStep(new FinalStep());
    }

    public BuildStepBuilder addBuildStep(BuildStep buildStep) {
        BuildStepBuilder buildStepBuilder = new BuildStepBuilder(this);
        buildStepBuilder.setBuildStep(buildStep);
        return buildStepBuilder;
    }

    public BuildStepBuilder addBuildStep() {
        return new BuildStepBuilder(this);
    }

    public BuildChainBuilder addInitial(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.initialIds.add(new ItemId(type));
        return this;
    }

    public BuildChainBuilder loadProviders(ClassLoader classLoader) throws ChainBuildException {
        ServiceLoader<BuildProvider> serviceLoader = ServiceLoader.load(BuildProvider.class, classLoader);
        for (BuildProvider provider : serviceLoader) {
            provider.installInto(this);
        }
        return this;
    }

    public BuildChainBuilder addFinal(Class<? extends BuildItem> type) {
        Assert.checkNotNullParam((String)"type", type);
        this.finalIds.add(new ItemId(type));
        return this;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BuildChain build() throws ChainBuildException {
        BuildStepBuilder stepBuilder;
        HashSet<ItemId> consumed = new HashSet<ItemId>();
        HashMap<BuildStepBuilder, StepInfo> mappedSteps = new HashMap<BuildStepBuilder, StepInfo>();
        int initialSingleCount = 0;
        int initialMultiCount = 0;
        Map<BuildStepBuilder, StackTraceElement[]> steps = this.steps;
        HashMap<ItemId, List> allConsumes = new HashMap<ItemId, List>();
        HashMap<ItemId, List<Produce>> allProduces = new HashMap<ItemId, List<Produce>>();
        Set<ItemId> initialIds = this.initialIds;
        for (Map.Entry<BuildStepBuilder, StackTraceElement[]> stepEntry : steps.entrySet()) {
            BuildStepBuilder stepBuilder2 = stepEntry.getKey();
            Map<ItemId, Consume> stepConsumes = stepBuilder2.getConsumes();
            for (Map.Entry<ItemId, Consume> entry : stepConsumes.entrySet()) {
                ItemId id = entry.getKey();
                List list = allConsumes.computeIfAbsent(id, x -> new ArrayList(4));
                list.add(entry.getValue());
            }
            Map<ItemId, Produce> stepProduces = stepBuilder2.getProduces();
            for (Object entry3 : stepProduces.entrySet()) {
                ItemId itemId = (ItemId)entry3.getKey();
                List list = allProduces.computeIfAbsent(itemId, x -> new ArrayList(2));
                Produce toBeAdded = (Produce)entry3.getValue();
                if (!itemId.isMulti() && toBeAdded.getConstraint() == Constraint.REAL) {
                    if (initialIds.contains(itemId)) {
                        ChainBuildException cbe = new ChainBuildException("Item " + itemId + " cannot be produced here (it is an initial resource) (" + toBeAdded.getStepBuilder().getBuildStep() + ")");
                        cbe.setStackTrace(steps.get(toBeAdded.getStepBuilder()));
                        throw cbe;
                    }
                    boolean overridable = toBeAdded.isOverridable();
                    for (Produce produce : list) {
                        if (produce.getConstraint() != Constraint.REAL || produce.isOverridable() != overridable) continue;
                        Throwable cause = new Throwable("This is the location of the conflicting producer (" + toBeAdded.getStepBuilder().getBuildStep() + ")");
                        cause.setStackTrace(steps.get(toBeAdded.getStepBuilder()));
                        ChainBuildException cbe = new ChainBuildException(String.format("Multiple %sproducers of item %s (%s)", overridable ? "overridable " : "", itemId, produce.getStepBuilder().getBuildStep()), cause);
                        cbe.setStackTrace(steps.get(produce.getStepBuilder()));
                        throw cbe;
                    }
                }
                list.add(toBeAdded);
            }
        }
        HashSet<BuildStepBuilder> included = new HashSet<BuildStepBuilder>();
        Set<ItemId> finalIds = this.finalIds;
        ArrayDeque<BuildStepBuilder> toAdd = new ArrayDeque<BuildStepBuilder>();
        HashSet<Produce> lastDependencies = new HashSet<Produce>();
        for (ItemId itemId : finalIds) {
            this.addOne(allProduces, included, toAdd, itemId, lastDependencies);
        }
        HashMap<BuildStepBuilder, Set<Produce>> hashMap = new HashMap<BuildStepBuilder, Set<Produce>>();
        while ((stepBuilder = (BuildStepBuilder)toAdd.pollFirst()) != null) {
            for (Map.Entry entry : stepBuilder.getConsumes().entrySet()) {
                Consume consume = (Consume)entry.getValue();
                ItemId id = (ItemId)entry.getKey();
                if (!(consume.getFlags().contains(ConsumeFlag.OPTIONAL) || id.isMulti() || initialIds.contains(id) || allProduces.containsKey(id))) {
                    throw new ChainBuildException("No producers for required item " + id);
                }
                this.addOne(allProduces, included, toAdd, id, hashMap.computeIfAbsent(stepBuilder, x -> new HashSet()));
            }
        }
        HashMap<BuildStepBuilder, Set<BuildStepBuilder>> dependents = new HashMap<BuildStepBuilder, Set<BuildStepBuilder>>();
        for (Map.Entry entry : hashMap.entrySet()) {
            BuildStepBuilder dependent = (BuildStepBuilder)entry.getKey();
            for (Produce produce : (Set)entry.getValue()) {
                dependents.computeIfAbsent(produce.getStepBuilder(), x -> new HashSet()).add(dependent);
            }
        }
        this.cycleCheck(included, new HashSet<BuildStepBuilder>(), new HashSet<BuildStepBuilder>(), hashMap, new ArrayDeque<Produce>());
        HashSet<StepInfo> hashSet = new HashSet<StepInfo>();
        HashSet<StepInfo> hashSet2 = new HashSet<StepInfo>();
        for (BuildStepBuilder builder : included) {
            this.buildOne(builder, included, mappedSteps, dependents, hashMap, hashSet, hashSet2);
        }
        if (GRAPH_OUTPUT != null && !GRAPH_OUTPUT.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(GRAPH_OUTPUT);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 BufferedWriter writer = new BufferedWriter(osw);){
                writer.write("digraph {");
                writer.newLine();
                writer.write("    node [shape=rectangle];");
                writer.newLine();
                writer.write("    rankdir=LR;");
                writer.newLine();
                writer.newLine();
                writer.write("    { rank = same; ");
                for (StepInfo startStep : hashSet) {
                    writer.write(BuildChainBuilder.quoteString(startStep.getBuildStep().toString()));
                    writer.write("; ");
                }
                writer.write("};");
                writer.newLine();
                writer.write("    { rank = same; ");
                for (StepInfo endStep : hashSet2) {
                    if (hashSet.contains(endStep)) continue;
                    writer.write(BuildChainBuilder.quoteString(endStep.getBuildStep().toString()));
                    writer.write("; ");
                }
                writer.write("};");
                writer.newLine();
                writer.newLine();
                HashSet<StepInfo> printed = new HashSet<StepInfo>();
                for (StepInfo step : hashSet) {
                    BuildChainBuilder.writeStep(writer, printed, step);
                }
                writer.write("}");
                writer.newLine();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to write debug graph output", ioe);
            }
        }
        return new BuildChain(initialSingleCount, initialMultiCount, hashSet, consumed, this, hashSet2.size());
    }

    private static void writeStep(BufferedWriter writer, HashSet<StepInfo> printed, StepInfo step) throws IOException {
        if (printed.add(step)) {
            String currentStepName = BuildChainBuilder.quoteString(step.getBuildStep().toString());
            Set<StepInfo> dependents = step.getDependents();
            if (!dependents.isEmpty()) {
                for (StepInfo dependent : dependents) {
                    String dependentName = BuildChainBuilder.quoteString(dependent.getBuildStep().toString());
                    writer.write("    ");
                    writer.write(dependentName);
                    writer.write(" -> ");
                    writer.write(currentStepName);
                    writer.newLine();
                }
                writer.newLine();
                for (StepInfo dependent : dependents) {
                    BuildChainBuilder.writeStep(writer, printed, dependent);
                }
            }
        }
    }

    private static String quoteString(String input) {
        Matcher matcher = QUOTE_PATTERN.matcher(input);
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        while (matcher.find()) {
            matcher.appendReplacement(buf, "\\" + matcher.group(0));
        }
        matcher.appendTail(buf);
        buf.append('\"');
        return buf.toString();
    }

    private void cycleCheck(Set<BuildStepBuilder> builders, Set<BuildStepBuilder> visited, Set<BuildStepBuilder> checked, Map<BuildStepBuilder, Set<Produce>> dependencies, Deque<Produce> producedPath) throws ChainBuildException {
        for (BuildStepBuilder builder : builders) {
            this.cycleCheck(builder, visited, checked, dependencies, producedPath);
        }
    }

    private void cycleCheckProduce(Set<Produce> produceSet, Set<BuildStepBuilder> visited, Set<BuildStepBuilder> checked, Map<BuildStepBuilder, Set<Produce>> dependencies, Deque<Produce> producedPath) throws ChainBuildException {
        for (Produce produce : produceSet) {
            producedPath.add(produce);
            this.cycleCheck(produce.getStepBuilder(), visited, checked, dependencies, producedPath);
            producedPath.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleCheck(BuildStepBuilder builder, Set<BuildStepBuilder> visited, Set<BuildStepBuilder> checked, Map<BuildStepBuilder, Set<Produce>> dependencies, Deque<Produce> producedPath) throws ChainBuildException {
        if (!checked.contains(builder)) {
            if (!visited.add(builder)) {
                StringBuilder b = new StringBuilder("Cycle detected:\n\t\t   ");
                Iterator<Produce> itr = producedPath.descendingIterator();
                if (itr.hasNext()) {
                    Produce produce = itr.next();
                    do {
                        b.append(produce.getStepBuilder().getBuildStep());
                        ItemId itemId = produce.getItemId();
                        b.append(" produced ").append(itemId);
                        b.append("\n\t\tto ");
                    } while (itr.hasNext() && (produce = itr.next()).getStepBuilder() != builder);
                    b.append(builder.getBuildStep());
                }
                throw new ChainBuildException(b.toString());
            }
            try {
                Set<Produce> dependencySet = dependencies.getOrDefault(builder, Collections.emptySet());
                this.cycleCheckProduce(dependencySet, visited, checked, dependencies, producedPath);
            }
            finally {
                visited.remove(builder);
            }
        }
        checked.add(builder);
    }

    private void addOne(Map<ItemId, List<Produce>> allProduces, Set<BuildStepBuilder> included, ArrayDeque<BuildStepBuilder> toAdd, ItemId idToAdd, Set<Produce> dependencies) throws ChainBuildException {
        BuildStepBuilder stepBuilder;
        boolean modified = false;
        for (Produce produce : allProduces.getOrDefault(idToAdd, Collections.emptyList())) {
            stepBuilder = produce.getStepBuilder();
            if (produce.getFlags().contains(ProduceFlag.OVERRIDABLE)) continue;
            if (!produce.getFlags().contains(ProduceFlag.WEAK) && included.add(stepBuilder)) {
                toAdd.addLast(stepBuilder);
            }
            dependencies.add(produce);
            modified = true;
        }
        if (modified) {
            return;
        }
        for (Produce produce : allProduces.getOrDefault(idToAdd, Collections.emptyList())) {
            stepBuilder = produce.getStepBuilder();
            if (!produce.getFlags().contains(ProduceFlag.OVERRIDABLE)) continue;
            if (!produce.getFlags().contains(ProduceFlag.WEAK) && included.add(stepBuilder)) {
                toAdd.addLast(stepBuilder);
            }
            dependencies.add(produce);
        }
    }

    private StepInfo buildOne(BuildStepBuilder toBuild, Set<BuildStepBuilder> included, Map<BuildStepBuilder, StepInfo> mapped, Map<BuildStepBuilder, Set<BuildStepBuilder>> dependents, Map<BuildStepBuilder, Set<Produce>> dependencies, Set<StepInfo> startSteps, Set<StepInfo> endSteps) {
        if (mapped.containsKey(toBuild)) {
            return mapped.get(toBuild);
        }
        HashSet<StepInfo> dependentStepInfos = new HashSet<StepInfo>();
        Set dependentsOfThis = dependents.getOrDefault(toBuild, Collections.emptySet());
        for (BuildStepBuilder dependentBuilder : dependentsOfThis) {
            if (!included.contains(dependentBuilder)) continue;
            dependentStepInfos.add(this.buildOne(dependentBuilder, included, mapped, dependents, dependencies, startSteps, endSteps));
        }
        Set dependenciesOfThis = dependencies.getOrDefault(toBuild, Collections.emptySet());
        int includedDependencies = 0;
        HashSet<BuildStepBuilder> visited = new HashSet<BuildStepBuilder>();
        for (Object produce : dependenciesOfThis) {
            BuildStepBuilder stepBuilder = ((Produce)produce).getStepBuilder();
            if (!included.contains(stepBuilder) || !visited.add(stepBuilder)) continue;
            ++includedDependencies;
        }
        int includedDependents = 0;
        for (BuildStepBuilder dependent : dependentsOfThis) {
            if (!included.contains(dependent)) continue;
            ++includedDependents;
        }
        StepInfo stepInfo = new StepInfo(toBuild, includedDependencies, dependentStepInfos);
        mapped.put(toBuild, stepInfo);
        if (includedDependencies == 0) {
            startSteps.add(stepInfo);
        }
        if (includedDependents == 0) {
            endSteps.add(stepInfo);
        }
        return stepInfo;
    }

    void addProvider(BuildProvider provider) throws ChainBuildException {
        this.providers.add(provider);
        provider.installInto(this);
    }

    void addStep(BuildStepBuilder stepBuilder, StackTraceElement[] stackTrace) {
        if (stepBuilder.getBuildStep() == null) {
            throw new IllegalArgumentException("Null build step");
        }
        this.steps.put(stepBuilder, stackTrace);
    }

    BuildStepBuilder getFinalStep() {
        return this.finalStep;
    }

    List<BuildProvider> getProviders() {
        return this.providers;
    }

    Map<BuildStepBuilder, StackTraceElement[]> getSteps() {
        return this.steps;
    }

    Set<ItemId> getInitialIds() {
        return this.initialIds;
    }

    Set<ItemId> getFinalIds() {
        return this.finalIds;
    }
}

