/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.execution;

import io.rainfall.AssertionEvaluator;
import io.rainfall.Configuration;
import io.rainfall.Execution;
import io.rainfall.Operation;
import io.rainfall.Scenario;
import io.rainfall.TestException;
import io.rainfall.configuration.ConcurrencyConfig;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.utils.RangeMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Times
extends Execution {
    private final long occurrences;

    public Times(long occurrences) {
        this.occurrences = occurrences;
    }

    @Override
    public <E extends Enum<E>> void execute(final StatisticsHolder<E> statisticsHolder, final Scenario scenario, final Map<Class<? extends Configuration>, Configuration> configurations, final List<AssertionEvaluator> assertions) throws TestException {
        ConcurrencyConfig concurrencyConfig = (ConcurrencyConfig)configurations.get(ConcurrencyConfig.class);
        int nbThreads = concurrencyConfig.getNbThreads();
        ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        this.markExecutionState(scenario, Execution.ExecutionState.BEGINNING);
        for (int threadNb = 0; threadNb < nbThreads; ++threadNb) {
            final long max = concurrencyConfig.getNbIterationsForThread(threadNb, this.occurrences);
            executor.submit(new Callable(){

                public Object call() throws Exception {
                    Thread.currentThread().setName("Rainfall-core Operations Thread");
                    List<RangeMap<Operation>> operations = scenario.getOperations();
                    for (long i = 0L; i < max; ++i) {
                        for (RangeMap<Operation> operation : operations) {
                            operation.get(Times.this.weightRnd.nextFloat(operation.getHigherBound().floatValue())).exec(statisticsHolder, configurations, assertions);
                        }
                    }
                    return null;
                }
            });
        }
        this.markExecutionState(scenario, Execution.ExecutionState.ENDING);
        executor.shutdown();
        try {
            long timeoutInSeconds = ((ConcurrencyConfig)configurations.get(ConcurrencyConfig.class)).getTimeoutInSeconds();
            boolean success = executor.awaitTermination(timeoutInSeconds, TimeUnit.SECONDS);
            if (!success) {
                throw new TestException("Execution of Scenario timed out after " + timeoutInSeconds + " seconds.");
            }
        }
        catch (InterruptedException e) {
            throw new TestException("Execution of Scenario didn't stop correctly.", e);
        }
    }

    @Override
    public String getDescription() {
        return this.occurrences + " occurences";
    }
}

