/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.generator.sequence;

import io.rainfall.utils.ConcurrentPseudoRandom;
import java.util.Random;

public enum Distribution {
    FLAT{

        @Override
        public long generate(ConcurrentPseudoRandom rnd, long minimum, long maximum, long width) {
            return Math.abs(rnd.nextLong()) % (maximum - minimum) + minimum;
        }

        @Override
        public String getDescription() {
            return "Flat";
        }
    }
    ,
    SLOW_GAUSSIAN{
        Random rndm = new Random();

        @Override
        public long generate(ConcurrentPseudoRandom rnd, long minimum, long maximum, long width) {
            long candidate;
            while ((candidate = (long)(this.rndm.nextGaussian() * (double)width + ((double)maximum + (double)minimum) / 2.0)) < minimum || candidate >= maximum) {
            }
            return candidate;
        }

        @Override
        public String getDescription() {
            return "Slow Gaussian";
        }
    }
    ,
    SLOW_GAUSSIAN_PARETO{
        Random rndm = new Random();

        @Override
        public long generate(ConcurrentPseudoRandom rnd, long minimum, long maximum, long ignore) {
            long candidate;
            long width = (long)(0.7 * (double)(maximum - minimum));
            while ((candidate = (long)(this.rndm.nextGaussian() * (double)width + ((double)maximum + (double)minimum) / 2.0)) < minimum || candidate >= maximum) {
            }
            return candidate;
        }

        @Override
        public String getDescription() {
            return "Slow Gaussian with Pareto distribution";
        }
    }
    ,
    GAUSSIAN{

        @Override
        public long generate(ConcurrentPseudoRandom rnd, long minimum, long maximum, long width) {
            long candidate;
            float y;
            float x;
            double r;
            long center = minimum + (maximum - minimum) / 2L;
            double stdDev = width;
            while ((r = (double)((x = 2.0f * rnd.nextFloat() - 1.0f) * x + (y = 2.0f * rnd.nextFloat() - 1.0f) * y)) == 0.0 || r > 1.0 || (candidate = (long)((double)x * (r = Math.sqrt(-2.0 * Math.log(r) / r)) * (double)width + (double)center)) < minimum || candidate >= maximum) {
            }
            return candidate;
        }

        @Override
        public String getDescription() {
            return "Gaussian";
        }
    };


    public abstract long generate(ConcurrentPseudoRandom var1, long var2, long var4, long var6);

    public abstract String getDescription();
}

