/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import io.rainfall.statistics.StatisticsPeek;
import java.util.concurrent.ConcurrentHashMap;
import jsr166e.LongAdder;

public class Statistics<E extends Enum<E>> {
    private final String name;
    private Enum<E>[] results;
    private final ConcurrentHashMap<Enum, LongAdder> periodicCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<Enum, LongAdder> periodicTotalLatenciesInNs = new ConcurrentHashMap();
    private final ConcurrentHashMap<Enum, LongAdder> cumulativeCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<Enum, LongAdder> cumulativeTotalLatenciesInNs = new ConcurrentHashMap();
    private Long periodicStartTime;
    private Long cumulativeStartTime;

    public Statistics(String name, Enum<E>[] results) {
        this.name = name;
        this.results = results;
        for (Enum<E> result : results) {
            this.periodicCounters.put(result, new LongAdder());
            this.periodicTotalLatenciesInNs.put(result, new LongAdder());
            this.cumulativeCounters.put(result, new LongAdder());
            this.cumulativeTotalLatenciesInNs.put(result, new LongAdder());
        }
        this.cumulativeStartTime = this.periodicStartTime = Long.valueOf(this.getTimeInNs());
    }

    Statistics(String name, Enum<E>[] results, long startTime) {
        this.results = results;
        this.name = name;
        for (Enum<E> result : results) {
            this.periodicCounters.put(result, new LongAdder());
            this.periodicTotalLatenciesInNs.put(result, new LongAdder());
            this.cumulativeCounters.put(result, new LongAdder());
            this.cumulativeTotalLatenciesInNs.put(result, new LongAdder());
        }
        this.cumulativeStartTime = this.periodicStartTime = Long.valueOf(startTime);
    }

    LongAdder getPeriodicCounters(Enum result) {
        return this.periodicCounters.get(result);
    }

    LongAdder getPeriodicTotalLatenciesInNs(Enum result) {
        return this.periodicTotalLatenciesInNs.get(result);
    }

    LongAdder getCumulativeCounters(Enum result) {
        return this.cumulativeCounters.get(result);
    }

    LongAdder getCumulativeTotalLatencies(Enum result) {
        return this.cumulativeTotalLatenciesInNs.get(result);
    }

    public void increaseCounterAndSetLatencyInNs(Enum result, long latency) {
        this.periodicCounters.get(result).increment();
        this.periodicTotalLatenciesInNs.get(result).add(latency);
    }

    public String getName() {
        return this.name;
    }

    protected long getTimeInNs() {
        return System.nanoTime();
    }

    public synchronized long getCurrentTps(Enum result) {
        long time = this.getTimeInNs() - this.periodicStartTime;
        return time < 1000000L ? this.periodicCounters.get(result).longValue() : this.periodicCounters.get(result).longValue() * 1000L * 1000000L / time;
    }

    public synchronized StatisticsPeek<E> peek(long timestamp) {
        StatisticsPeek<E> statisticsPeek = new StatisticsPeek<E>(this.name, this.results, timestamp);
        long now = this.getTimeInNs();
        statisticsPeek.setPeriodicValues(now - this.periodicStartTime, this.periodicCounters, this.periodicTotalLatenciesInNs);
        for (Enum<E> key : this.results) {
            this.cumulativeCounters.get(key).add(this.periodicCounters.get(key).sumThenReset());
            this.cumulativeTotalLatenciesInNs.get(key).add(this.periodicTotalLatenciesInNs.get(key).sumThenReset());
        }
        statisticsPeek.setCumulativeValues(now - this.cumulativeStartTime, this.cumulativeCounters, this.cumulativeTotalLatenciesInNs);
        this.periodicStartTime = this.getTimeInNs();
        return statisticsPeek;
    }

    public void reset() {
        for (Enum<E> key : this.results) {
            this.periodicCounters.get(key).reset();
            this.periodicTotalLatenciesInNs.get(key).reset();
            this.cumulativeCounters.get(key).reset();
            this.cumulativeTotalLatenciesInNs.get(key).reset();
        }
        this.cumulativeStartTime = this.periodicStartTime = Long.valueOf(this.getTimeInNs());
    }
}

