/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import io.rainfall.Reporter;
import io.rainfall.configuration.ReportingConfig;
import io.rainfall.statistics.RuntimeStatisticsHolder;
import io.rainfall.statistics.StatisticsPeekHolder;
import io.rainfall.statistics.collector.StatisticsCollector;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;

public class StatisticsThread<E extends Enum<E>>
extends TimerTask {
    private RuntimeStatisticsHolder<E> statisticsHolder;
    private ReportingConfig<E> reportingConfig;
    private final Set<StatisticsCollector> statisticsCollectors;
    private List<String> description;

    public StatisticsThread(RuntimeStatisticsHolder<E> statisticsHolder, ReportingConfig<E> reportingConfig, List<String> description, Set<StatisticsCollector> statisticsCollectors) {
        this.description = description;
        Thread.currentThread().setName("Rainfall-core Statistics Thread");
        this.statisticsHolder = statisticsHolder;
        this.reportingConfig = reportingConfig;
        this.statisticsCollectors = statisticsCollectors;
        for (StatisticsCollector statisticsCollector : statisticsCollectors) {
            statisticsCollector.initialize();
        }
        Set<Reporter<E>> reporters = reportingConfig.getLogReporters();
        for (Reporter<E> reporter : reporters) {
            reporter.header(description);
        }
    }

    @Override
    public void run() {
        StatisticsPeekHolder<E> peek = this.statisticsHolder.peek();
        Set<Reporter<E>> reporters = this.reportingConfig.getLogReporters();
        for (Reporter<E> reporter : reporters) {
            reporter.report(peek);
        }
    }

    public StatisticsPeekHolder<E> stop() {
        StatisticsPeekHolder<E> peek = this.statisticsHolder.peek();
        for (StatisticsCollector statisticsCollector : this.reportingConfig.getStatisticsCollectors()) {
            statisticsCollector.terminate();
        }
        Set<Reporter<E>> reporters = this.reportingConfig.getLogReporters();
        for (Reporter<E> reporter : reporters) {
            reporter.summarize(this.statisticsHolder);
        }
        super.cancel();
        return peek;
    }
}

