/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics.monitor;

import io.rainfall.reporting.HtmlReporter;
import io.rainfall.statistics.collector.StatisticsCollector;
import io.rainfall.statistics.exporter.Exporter;
import io.rainfall.statistics.exporter.HtmlExporter;
import io.rainfall.statistics.exporter.TextExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class OSStatisticsCollector
implements StatisticsCollector {
    private static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private static final String OS_STATS = "Processor Utilization";
    private static final int AVAILABLE_PROCESSORS = OS_BEAN.getAvailableProcessors();
    private Writer osOutput;

    @Override
    public void initialize() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public Exporter peek() {
        return new OSStatisticsExporter(System.currentTimeMillis(), OS_BEAN.getSystemLoadAverage() / (double)AVAILABLE_PROCESSORS * 100.0);
    }

    @Override
    public String getName() {
        return OS_STATS;
    }

    public class OSStatisticsExporter
    implements HtmlExporter,
    TextExporter {
        private HtmlReporter reporterUtils = new HtmlReporter();
        private String osFile = "os.csv";
        private long timestamp;
        private double processorUsage;

        public OSStatisticsExporter(long timestamp, double processorUsage) {
            this.timestamp = timestamp;
            this.processorUsage = processorUsage;
        }

        @Override
        public void ouputText() {
        }

        @Override
        public void ouputCsv(String basedir) throws Exception {
            String osFilename = basedir + File.separatorChar + this.osFile;
            OSStatisticsCollector.this.osOutput = new BufferedWriter(new FileWriter(osFilename, true));
            if (new File(osFilename).length() == 0L) {
                this.reporterUtils.addHeader(OSStatisticsCollector.this.osOutput, Header.values());
            }
            OSStatisticsCollector.this.osOutput.append(this.reporterUtils.formatTimestampInNano(this.timestamp) + "," + this.processorUsage);
            OSStatisticsCollector.this.osOutput.close();
        }

        @Override
        public String outputHtml() {
            return "    function reportOS(filename, title) {\n        $(\"#os-box\").append(\"<div id='\" + filename + 'os' + \"' style='height: 550px;width: 1200px;'><div class='title'/><div class='graph'/></div>\");\n        d3.csv(filename + \".csv\", function (data) { processData(data, filename + 'os', title, 'Processor Utilization') });\n    }\n\n$('body').append('<div class=\"border\"><h1><a name=\"os\">Processor Utilization</a></h1><div id=\"os-box\"></div></div><br/>');\nreportOS('os', 'Processor Utilization');\n";
        }
    }

    public static enum Header {
        PROCESSOR_UTILIZATION;

    }
}

